rule win_t34loader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.t34loader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.t34loader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d0d13700400 807b5704 7704 488b4b48 4c8bc6 33d2 e8???????? }
            // n = 7, score = 100
            //   488d0d13700400       | dec                 eax
            //   807b5704             | mov                 ebx, dword ptr [esp + 0x50]
            //   7704                 | jmp                 0x7ab
            //   488b4b48             | mov                 edx, 1
            //   4c8bc6               | movzx               ecx, word ptr [edi + 0xa]
            //   33d2                 | dec                 eax
            //   e8????????           |                     

        $sequence_1 = { cd29 488d0deaba0400 e8???????? 488b442438 488905???????? 488d442438 }
            // n = 6, score = 100
            //   cd29                 | dec                 eax
            //   488d0deaba0400       | mov                 ecx, esi
            //   e8????????           |                     
            //   488b442438           | dec                 eax
            //   488905????????       |                     
            //   488d442438           | mov                 ebx, eax

        $sequence_2 = { 4c897610 488bd5 e8???????? 498d0c36 eb59 498bd6 e8???????? }
            // n = 7, score = 100
            //   4c897610             | movsx               eax, byte ptr [esi + 0x53]
            //   488bd5               | dec                 eax
            //   e8????????           |                     
            //   498d0c36             | lea                 edx, [0x3670b]
            //   eb59                 | dec                 esp
            //   498bd6               | lea                 edx, [0x36718]
            //   e8????????           |                     

        $sequence_3 = { 448b45fc 4803cb e8???????? 0fb74706 488d6d28 ffc6 }
            // n = 6, score = 100
            //   448b45fc             | mov                 byte ptr [eax], dl
            //   4803cb               | inc                 esp
            //   e8????????           |                     
            //   0fb74706             | mov                 ch, byte ptr [esp + 0x32]
            //   488d6d28             | inc                 ecx
            //   ffc6                 | mov                 al, ch

        $sequence_4 = { 488bd9 4885d2 7504 33c0 eb10 4883c128 e8???????? }
            // n = 7, score = 100
            //   488bd9               | dec                 esp
            //   4885d2               | mov                 eax, dword ptr [ebx]
            //   7504                 | dec                 eax
            //   33c0                 | lea                 edx, [ebp - 0x78]
            //   eb10                 | dec                 eax
            //   4883c128             | lea                 ecx, [esp + 0x28]
            //   e8????????           |                     

        $sequence_5 = { 0f84f4000000 498b01 488903 40886b10 e9???????? }
            // n = 5, score = 100
            //   0f84f4000000         | inc                 esp
            //   498b01               | mov                 dword ptr [esp + 0x34], edi
            //   488903               | dec                 eax
            //   40886b10             | lea                 ecx, [ebp - 0x10]
            //   e9????????           |                     

        $sequence_6 = { 4533c0 410fb717 488bcd 488b4070 ff15???????? 3c3a 0f8581000000 }
            // n = 7, score = 100
            //   4533c0               | mov                 edx, 0x5a5bc870
            //   410fb717             | clc                 
            //   488bcd               | push                ds
            //   488b4070             | pop                 ebp
            //   ff15????????         |                     
            //   3c3a                 | ret                 0x8d4c
            //   0f8581000000         | add                 eax, 0xfffbc15c

        $sequence_7 = { 0f8590090000 4883fb03 0f8486090000 458af1 488bd6 488bcf e8???????? }
            // n = 7, score = 100
            //   0f8590090000         | mov                 dword ptr [ebp + 0x10], eax
            //   4883fb03             | dec                 eax
            //   0f8486090000         | lea                 ecx, [ebp + 0x1820]
            //   458af1               | dec                 eax
            //   488bd6               | lea                 ecx, [ebp + 0x3328]
            //   488bcf               | dec                 eax
            //   e8????????           |                     

        $sequence_8 = { 448bcb ba02100000 498bce ff15???????? 85c0 7508 ff15???????? }
            // n = 7, score = 100
            //   448bcb               | lea                 ecx, [ebp - 0x21]
            //   ba02100000           | dec                 esp
            //   498bce               | lea                 eax, [0x4e0cb]
            //   ff15????????         |                     
            //   85c0                 | dec                 eax
            //   7508                 | lea                 edx, [0x4e0a9]
            //   ff15????????         |                     

        $sequence_9 = { 4533c0 4889442420 ff15???????? 488d542450 488d4c2430 e8???????? 488d9580070000 }
            // n = 7, score = 100
            //   4533c0               | test                byte ptr [eax + edi*8 + 0x38], 0x48
            //   4889442420           | je                  0x1c2
            //   ff15????????         |                     
            //   488d542450           | movzx               eax, word ptr [esp + 0x70]
            //   488d4c2430           | inc                 cx
            //   e8????????           |                     
            //   488d9580070000       | cmp                 eax, ebp

    condition:
        7 of them and filesize < 1212416
}