rule win_telandext_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.telandext"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b5308 e8???????? e9???????? 33c0 55 68???????? 64ff30 }
            // n = 7, score = 100
            //   8b5308               | mov                 edx, dword ptr [ebx + 8]
            //   e8????????           |                     
            //   e9????????           |                     
            //   33c0                 | xor                 eax, eax
            //   55                   | push                ebp
            //   68????????           |                     
            //   64ff30               | push                dword ptr fs:[eax]

        $sequence_1 = { 8b55e0 e8???????? 8b85acfeffff e8???????? 6a00 8d85a8feffff }
            // n = 6, score = 100
            //   8b55e0               | mov                 edx, dword ptr [ebp - 0x20]
            //   e8????????           |                     
            //   8b85acfeffff         | mov                 eax, dword ptr [ebp - 0x154]
            //   e8????????           |                     
            //   6a00                 | push                0
            //   8d85a8feffff         | lea                 eax, [ebp - 0x158]

        $sequence_2 = { 014344 8b4b4c d36df0 2b734c 8b83c81b0000 03434c 8983c81b0000 }
            // n = 7, score = 100
            //   014344               | add                 dword ptr [ebx + 0x44], eax
            //   8b4b4c               | mov                 ecx, dword ptr [ebx + 0x4c]
            //   d36df0               | shr                 dword ptr [ebp - 0x10], cl
            //   2b734c               | sub                 esi, dword ptr [ebx + 0x4c]
            //   8b83c81b0000         | mov                 eax, dword ptr [ebx + 0x1bc8]
            //   03434c               | add                 eax, dword ptr [ebx + 0x4c]
            //   8983c81b0000         | mov                 dword ptr [ebx + 0x1bc8], eax

        $sequence_3 = { 8b45f8 5a 8b18 ff5370 6a01 68???????? 68???????? }
            // n = 7, score = 100
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   5a                   | pop                 edx
            //   8b18                 | mov                 ebx, dword ptr [eax]
            //   ff5370               | call                dword ptr [ebx + 0x70]
            //   6a01                 | push                1
            //   68????????           |                     
            //   68????????           |                     

        $sequence_4 = { 51 8b0d???????? 91 87ca 8b18 ff531c 5b }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   8b0d????????         |                     
            //   91                   | xchg                eax, ecx
            //   87ca                 | xchg                edx, ecx
            //   8b18                 | mov                 ebx, dword ptr [eax]
            //   ff531c               | call                dword ptr [ebx + 0x1c]
            //   5b                   | pop                 ebx

        $sequence_5 = { 8945ec 6a00 6a00 8d45d8 50 8b4dec 2b4df0 }
            // n = 7, score = 100
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   50                   | push                eax
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   2b4df0               | sub                 ecx, dword ptr [ebp - 0x10]

        $sequence_6 = { 8b0490 8b5704 81cac0000000 0bc2 0fb693a8020000 0b0495a8ab6a00 6683bbaa02000000 }
            // n = 7, score = 100
            //   8b0490               | mov                 eax, dword ptr [eax + edx*4]
            //   8b5704               | mov                 edx, dword ptr [edi + 4]
            //   81cac0000000         | or                  edx, 0xc0
            //   0bc2                 | or                  eax, edx
            //   0fb693a8020000       | movzx               edx, byte ptr [ebx + 0x2a8]
            //   0b0495a8ab6a00       | or                  eax, dword ptr [edx*4 + 0x6aaba8]
            //   6683bbaa02000000     | cmp                 word ptr [ebx + 0x2aa], 0

        $sequence_7 = { 8b1495a8b06a00 e8???????? eb7d 8d45fc 80c30d 80eb2d 0fb6d3 }
            // n = 7, score = 100
            //   8b1495a8b06a00       | mov                 edx, dword ptr [edx*4 + 0x6ab0a8]
            //   e8????????           |                     
            //   eb7d                 | jmp                 0x7f
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   80c30d               | add                 bl, 0xd
            //   80eb2d               | sub                 bl, 0x2d
            //   0fb6d3               | movzx               edx, bl

        $sequence_8 = { 648920 8d4ddc 8b45fc 8b00 8b55f8 8b18 ff530c }
            // n = 7, score = 100
            //   648920               | mov                 dword ptr fs:[eax], esp
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   8b18                 | mov                 ebx, dword ptr [eax]
            //   ff530c               | call                dword ptr [ebx + 0xc]

        $sequence_9 = { 8b45fc 8b5034 8d45e8 8b4dd0 e8???????? b201 8b45e8 }
            // n = 7, score = 100
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b5034               | mov                 edx, dword ptr [eax + 0x34]
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   8b4dd0               | mov                 ecx, dword ptr [ebp - 0x30]
            //   e8????????           |                     
            //   b201                 | mov                 dl, 1
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]

    condition:
        7 of them and filesize < 29818880
}