rule win_telb_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.telb."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.telb"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89742418 81fefeffff7f 7607 befeffff7f }
            // n = 4, score = 200
            //   89742418             | mov                 dword ptr [esp + 0x18], esi
            //   81fefeffff7f         | cmp                 esi, 0x7ffffffe
            //   7607                 | jbe                 9
            //   befeffff7f           | mov                 esi, 0x7ffffffe

        $sequence_1 = { 89bd38eeffff 33c0 89bd48eeffff 8bbd80efffff }
            // n = 4, score = 200
            //   89bd38eeffff         | mov                 dword ptr [ebp - 0x11c8], edi
            //   33c0                 | xor                 eax, eax
            //   89bd48eeffff         | mov                 dword ptr [ebp - 0x11b8], edi
            //   8bbd80efffff         | mov                 edi, dword ptr [ebp - 0x1080]

        $sequence_2 = { 03048d08e34100 50 ff15???????? 5d c3 8bff 55 }
            // n = 7, score = 200
            //   03048d08e34100       | add                 eax, dword ptr [ecx*4 + 0x41e308]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp

        $sequence_3 = { f30f7e4010 668908 8d4c2460 660fd6442470 }
            // n = 4, score = 200
            //   f30f7e4010           | movq                xmm0, qword ptr [eax + 0x10]
            //   668908               | mov                 word ptr [eax], cx
            //   8d4c2460             | lea                 ecx, [esp + 0x60]
            //   660fd6442470         | movq                qword ptr [esp + 0x70], xmm0

        $sequence_4 = { ff15???????? 83fe64 7cb2 8b8518eeffff 85c0 0f85b7000000 6a28 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   83fe64               | cmp                 esi, 0x64
            //   7cb2                 | jl                  0xffffffb4
            //   8b8518eeffff         | mov                 eax, dword ptr [ebp - 0x11e8]
            //   85c0                 | test                eax, eax
            //   0f85b7000000         | jne                 0xbd
            //   6a28                 | push                0x28

        $sequence_5 = { e8???????? 833d????????00 7426 68???????? ba???????? 8d4c2464 e8???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   833d????????00       |                     
            //   7426                 | je                  0x28
            //   68????????           |                     
            //   ba????????           |                     
            //   8d4c2464             | lea                 ecx, [esp + 0x64]
            //   e8????????           |                     

        $sequence_6 = { 52 51 e8???????? 83c408 8b542444 33c0 c744245800000000 }
            // n = 7, score = 200
            //   52                   | push                edx
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8b542444             | mov                 edx, dword ptr [esp + 0x44]
            //   33c0                 | xor                 eax, eax
            //   c744245800000000     | mov                 dword ptr [esp + 0x58], 0

        $sequence_7 = { 6a0d 68???????? 8d8d88efffff e8???????? 83bd0cefffff08 8d85f8eeffff 56 }
            // n = 7, score = 200
            //   6a0d                 | push                0xd
            //   68????????           |                     
            //   8d8d88efffff         | lea                 ecx, [ebp - 0x1078]
            //   e8????????           |                     
            //   83bd0cefffff08       | cmp                 dword ptr [ebp - 0x10f4], 8
            //   8d85f8eeffff         | lea                 eax, [ebp - 0x1108]
            //   56                   | push                esi

        $sequence_8 = { 83c404 8bc8 c645fc39 e8???????? 8d8d10efffff e8???????? 8d8db8efffff }
            // n = 7, score = 200
            //   83c404               | add                 esp, 4
            //   8bc8                 | mov                 ecx, eax
            //   c645fc39             | mov                 byte ptr [ebp - 4], 0x39
            //   e8????????           |                     
            //   8d8d10efffff         | lea                 ecx, [ebp - 0x10f0]
            //   e8????????           |                     
            //   8d8db8efffff         | lea                 ecx, [ebp - 0x1048]

        $sequence_9 = { 6689442438 e8???????? 8d4c2430 e8???????? 8d4c2430 e8???????? }
            // n = 6, score = 200
            //   6689442438           | mov                 word ptr [esp + 0x38], ax
            //   e8????????           |                     
            //   8d4c2430             | lea                 ecx, [esp + 0x30]
            //   e8????????           |                     
            //   8d4c2430             | lea                 ecx, [esp + 0x30]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 286720
}