rule win_teslacrypt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.teslacrypt."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.teslacrypt"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 334500 335d04 334d08 33550c 81ffa0000000 0f8452030000 }
            // n = 6, score = 900
            //   334500               | xor                 eax, dword ptr [ebp]
            //   335d04               | xor                 ebx, dword ptr [ebp + 4]
            //   334d08               | xor                 ecx, dword ptr [ebp + 8]
            //   33550c               | xor                 edx, dword ptr [ebp + 0xc]
            //   81ffa0000000         | cmp                 edi, 0xa0
            //   0f8452030000         | je                  0x358

        $sequence_1 = { 33457c 89859c000000 51 52 89f2 c1c808 0fb6c8 }
            // n = 7, score = 900
            //   33457c               | xor                 eax, dword ptr [ebp + 0x7c]
            //   89859c000000         | mov                 dword ptr [ebp + 0x9c], eax
            //   51                   | push                ecx
            //   52                   | push                edx
            //   89f2                 | mov                 edx, esi
            //   c1c808               | ror                 eax, 8
            //   0fb6c8               | movzx               ecx, al

        $sequence_2 = { 33550c 81ffa0000000 0f8456030000 81ffc0000000 0f84ae010000 }
            // n = 5, score = 900
            //   33550c               | xor                 edx, dword ptr [ebp + 0xc]
            //   81ffa0000000         | cmp                 edi, 0xa0
            //   0f8456030000         | je                  0x35c
            //   81ffc0000000         | cmp                 edi, 0xc0
            //   0f84ae010000         | je                  0x1b4

        $sequence_3 = { 0f84ac010000 81ffe0000000 740a b8ffffffff e9???????? }
            // n = 5, score = 900
            //   0f84ac010000         | je                  0x1b2
            //   81ffe0000000         | cmp                 edi, 0xe0
            //   740a                 | je                  0xc
            //   b8ffffffff           | mov                 eax, 0xffffffff
            //   e9????????           |                     

        $sequence_4 = { 3345f8 894518 3345fc 89451c }
            // n = 4, score = 900
            //   3345f8               | xor                 eax, dword ptr [ebp - 8]
            //   894518               | mov                 dword ptr [ebp + 0x18], eax
            //   3345fc               | xor                 eax, dword ptr [ebp - 4]
            //   89451c               | mov                 dword ptr [ebp + 0x1c], eax

        $sequence_5 = { 3345f4 894514 3345f8 894518 }
            // n = 4, score = 900
            //   3345f4               | xor                 eax, dword ptr [ebp - 0xc]
            //   894514               | mov                 dword ptr [ebp + 0x14], eax
            //   3345f8               | xor                 eax, dword ptr [ebp - 8]
            //   894518               | mov                 dword ptr [ebp + 0x18], eax

        $sequence_6 = { 3345fc 89451c 51 52 }
            // n = 4, score = 900
            //   3345fc               | xor                 eax, dword ptr [ebp - 4]
            //   89451c               | mov                 dword ptr [ebp + 0x1c], eax
            //   51                   | push                ecx
            //   52                   | push                edx

        $sequence_7 = { 334500 335d04 83c510 8b7508 }
            // n = 4, score = 900
            //   334500               | xor                 eax, dword ptr [ebp]
            //   335d04               | xor                 ebx, dword ptr [ebp + 4]
            //   83c510               | add                 ebp, 0x10
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]

        $sequence_8 = { 894c2434 89442430 8954242c 89742428 753a }
            // n = 5, score = 100
            //   894c2434             | mov                 dword ptr [esp + 0x34], ecx
            //   89442430             | mov                 dword ptr [esp + 0x30], eax
            //   8954242c             | mov                 dword ptr [esp + 0x2c], edx
            //   89742428             | mov                 dword ptr [esp + 0x28], esi
            //   753a                 | jne                 0x3c

        $sequence_9 = { 8b4c2418 83f900 894c2428 89442424 0f8540ffffff }
            // n = 5, score = 100
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]
            //   83f900               | cmp                 ecx, 0
            //   894c2428             | mov                 dword ptr [esp + 0x28], ecx
            //   89442424             | mov                 dword ptr [esp + 0x24], eax
            //   0f8540ffffff         | jne                 0xffffff46

        $sequence_10 = { 8954244c 894c2448 e8???????? 89442460 }
            // n = 4, score = 100
            //   8954244c             | mov                 dword ptr [esp + 0x4c], edx
            //   894c2448             | mov                 dword ptr [esp + 0x48], ecx
            //   e8????????           |                     
            //   89442460             | mov                 dword ptr [esp + 0x60], eax

        $sequence_11 = { 8b742410 39f1 8944240c 894c2408 88542407 }
            // n = 5, score = 100
            //   8b742410             | mov                 esi, dword ptr [esp + 0x10]
            //   39f1                 | cmp                 ecx, esi
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax
            //   894c2408             | mov                 dword ptr [esp + 8], ecx
            //   88542407             | mov                 byte ptr [esp + 7], dl

        $sequence_12 = { e8???????? 8d0dee304b00 8b542410 8902 890c24 e8???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8d0dee304b00         | lea                 ecx, [0x4b30ee]
            //   8b542410             | mov                 edx, dword ptr [esp + 0x10]
            //   8902                 | mov                 dword ptr [edx], eax
            //   890c24               | mov                 dword ptr [esp], ecx
            //   e8????????           |                     

        $sequence_13 = { 894a04 8b4c2468 890a e8???????? 83ec0c 31c9 8b54247c }
            // n = 7, score = 100
            //   894a04               | mov                 dword ptr [edx + 4], ecx
            //   8b4c2468             | mov                 ecx, dword ptr [esp + 0x68]
            //   890a                 | mov                 dword ptr [edx], ecx
            //   e8????????           |                     
            //   83ec0c               | sub                 esp, 0xc
            //   31c9                 | xor                 ecx, ecx
            //   8b54247c             | mov                 edx, dword ptr [esp + 0x7c]

        $sequence_14 = { 83f800 89442434 894c2458 0f842d010000 }
            // n = 4, score = 100
            //   83f800               | cmp                 eax, 0
            //   89442434             | mov                 dword ptr [esp + 0x34], eax
            //   894c2458             | mov                 dword ptr [esp + 0x58], ecx
            //   0f842d010000         | je                  0x133

        $sequence_15 = { 895c246c 89542468 89742464 897c2460 ffd6 83ec10 31c9 }
            // n = 7, score = 100
            //   895c246c             | mov                 dword ptr [esp + 0x6c], ebx
            //   89542468             | mov                 dword ptr [esp + 0x68], edx
            //   89742464             | mov                 dword ptr [esp + 0x64], esi
            //   897c2460             | mov                 dword ptr [esp + 0x60], edi
            //   ffd6                 | call                esi
            //   83ec10               | sub                 esp, 0x10
            //   31c9                 | xor                 ecx, ecx

    condition:
        7 of them and filesize < 1187840
}