rule win_thunderx_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.thunderx."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.thunderx"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4598 03c1 894d8c 6a0d 50 e8???????? 33f8 }
            // n = 7, score = 200
            //   8b4598               | mov                 eax, dword ptr [ebp - 0x68]
            //   03c1                 | add                 eax, ecx
            //   894d8c               | mov                 dword ptr [ebp - 0x74], ecx
            //   6a0d                 | push                0xd
            //   50                   | push                eax
            //   e8????????           |                     
            //   33f8                 | xor                 edi, eax

        $sequence_1 = { 57 b9???????? e8???????? 83f8ff 7413 837e1410 7202 }
            // n = 7, score = 200
            //   57                   | push                edi
            //   b9????????           |                     
            //   e8????????           |                     
            //   83f8ff               | cmp                 eax, -1
            //   7413                 | je                  0x15
            //   837e1410             | cmp                 dword ptr [esi + 0x14], 0x10
            //   7202                 | jb                  4

        $sequence_2 = { e8???????? 83c618 3b742428 75f0 8d4c2424 e8???????? e8???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c618               | add                 esi, 0x18
            //   3b742428             | cmp                 esi, dword ptr [esp + 0x28]
            //   75f0                 | jne                 0xfffffff2
            //   8d4c2424             | lea                 ecx, [esp + 0x24]
            //   e8????????           |                     
            //   e8????????           |                     

        $sequence_3 = { e8???????? 83c618 8975c0 eb0d 57 56 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   83c618               | add                 esi, 0x18
            //   8975c0               | mov                 dword ptr [ebp - 0x40], esi
            //   eb0d                 | jmp                 0xf
            //   57                   | push                edi
            //   56                   | push                esi

        $sequence_4 = { 8b36 53 56 ff7710 50 e8???????? 5e }
            // n = 7, score = 200
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   53                   | push                ebx
            //   56                   | push                esi
            //   ff7710               | push                dword ptr [edi + 0x10]
            //   50                   | push                eax
            //   e8????????           |                     
            //   5e                   | pop                 esi

        $sequence_5 = { 50 ff15???????? 85c0 0f85b7000000 837e1408 7202 8b36 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f85b7000000         | jne                 0xbd
            //   837e1408             | cmp                 dword ptr [esi + 0x14], 8
            //   7202                 | jb                  4
            //   8b36                 | mov                 esi, dword ptr [esi]

        $sequence_6 = { 56 57 6a66 50 ff15???????? 51 50 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a66                 | push                0x66
            //   50                   | push                eax
            //   ff15????????         |                     
            //   51                   | push                ecx
            //   50                   | push                eax

        $sequence_7 = { e8???????? eb24 8d4de0 e8???????? }
            // n = 4, score = 200
            //   e8????????           |                     
            //   eb24                 | jmp                 0x26
            //   8d4de0               | lea                 ecx, [ebp - 0x20]
            //   e8????????           |                     

        $sequence_8 = { 8932 897204 897208 5e 5d c20400 6a18 }
            // n = 7, score = 200
            //   8932                 | mov                 dword ptr [edx], esi
            //   897204               | mov                 dword ptr [edx + 4], esi
            //   897208               | mov                 dword ptr [edx + 8], esi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   6a18                 | push                0x18

        $sequence_9 = { 57 8955fc 8b7a14 8bc7 8b7210 2bc6 }
            // n = 6, score = 200
            //   57                   | push                edi
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   8b7a14               | mov                 edi, dword ptr [edx + 0x14]
            //   8bc7                 | mov                 eax, edi
            //   8b7210               | mov                 esi, dword ptr [edx + 0x10]
            //   2bc6                 | sub                 eax, esi

    condition:
        7 of them and filesize < 319488
}