rule win_tiger_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.tiger_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tiger_rat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4883c104 488bd0 488bd8 e8???????? }
            // n = 4, score = 200
            //   4883c104             | mov                 ebx, 0x80
            //   488bd0               | movzx               edx, byte ptr [ebp + edx - 0x2c]
            //   488bd8               | inc                 ecx
            //   e8????????           |                     

        $sequence_1 = { 4883c104 48895c2458 48894c2468 483bc8 }
            // n = 4, score = 200
            //   4883c104             | jmp                 7
            //   48895c2458           | mov                 ebx, 0x10000
            //   48894c2468           | dec                 eax
            //   483bc8               | mov                 edx, dword ptr [esp + 0x40]

        $sequence_2 = { 410fb6df 48c1e802 48c1e004 4803c8 }
            // n = 4, score = 200
            //   410fb6df             | dec                 eax
            //   48c1e802             | mov                 ebx, dword ptr [esp + 0x120]
            //   48c1e004             | xor                 al, al
            //   4803c8               | dec                 eax

        $sequence_3 = { 41bb80000000 0fb65415d4 41d3fb 4122d3 }
            // n = 4, score = 200
            //   41bb80000000         | shr                 eax, 2
            //   0fb65415d4           | dec                 eax
            //   41d3fb               | shl                 eax, 4
            //   4122d3               | dec                 eax

        $sequence_4 = { 2bdf eb05 bb00000100 488b542440 488b4c2450 }
            // n = 5, score = 200
            //   2bdf                 | jne                 0xffffffee
            //   eb05                 | test                edx, edx
            //   bb00000100           | je                  0x28
            //   488b542440           | inc                 ebx
            //   488b4c2450           | inc                 ecx

        $sequence_5 = { 4883c002 85c9 75ec 85d2 7422 ffc3 }
            // n = 6, score = 200
            //   4883c002             | inc                 ecx
            //   85c9                 | xor                 al, byte ptr [ebp + edx - 9]
            //   75ec                 | dec                 eax
            //   85d2                 | cmp                 ecx, 0xf
            //   7422                 | dec                 ecx
            //   ffc3                 | cmove               ecx, esi

        $sequence_6 = { 0f842d010000 48833d????????00 0f841f010000 48833d????????00 0f8411010000 48833d????????00 0f8403010000 }
            // n = 7, score = 200
            //   0f842d010000         | mov                 ecx, dword ptr [esp + 0x50]
            //   48833d????????00     |                     
            //   0f841f010000         | dec                 esp
            //   48833d????????00     |                     
            //   0f8411010000         | lea                 ecx, [ebp + 0x218]
            //   48833d????????00     |                     
            //   0f8403010000         | sub                 ebx, edi

        $sequence_7 = { 410fb6cf 0845d6 418bc2 48c1e807 480bc8 498bc3 4183e302 }
            // n = 7, score = 200
            //   410fb6cf             | mov                 ecx, ebx
            //   0845d6               | dec                 eax
            //   418bc2               | lea                 edx, [0xc171]
            //   48c1e807             | dec                 eax
            //   480bc8               | mov                 ecx, ebx
            //   498bc3               | dec                 eax
            //   4183e302             | mov                 ecx, dword ptr [ebp - 0x31]

        $sequence_8 = { 8905???????? e8???????? 8b05???????? 418bd6 0b05???????? }
            // n = 5, score = 100
            //   8905????????         |                     
            //   e8????????           |                     
            //   8b05????????         |                     
            //   418bd6               | dec                 eax
            //   0b05????????         |                     

        $sequence_9 = { 0f8423fdffff 4863c7 458bc5 488d9530060000 4803d0 488b442448 488d0d821f0100 }
            // n = 7, score = 100
            //   0f8423fdffff         | je                  0xfffffd29
            //   4863c7               | dec                 eax
            //   458bc5               | arpl                di, ax
            //   488d9530060000       | inc                 ebp
            //   4803d0               | mov                 eax, ebp
            //   488b442448           | dec                 eax
            //   488d0d821f0100       | lea                 edx, [ebp + 0x630]

        $sequence_10 = { 448d420a 8905???????? c744242014000000 ff15???????? }
            // n = 4, score = 100
            //   448d420a             | lea                 ecx, [0x1c8ba]
            //   8905????????         |                     
            //   c744242014000000     | mov                 edx, edi
            //   ff15????????         |                     

        $sequence_11 = { 4053 4883ec20 4883610800 488d0556d30000 c6411000 }
            // n = 5, score = 100
            //   4053                 | dec                 eax
            //   4883ec20             | lea                 ecx, [0x11f82]
            //   4883610800           | dec                 eax
            //   488d0556d30000       | test                eax, eax
            //   c6411000             | jne                 0x34

        $sequence_12 = { 4c8bc3 33d2 488bc8 e8???????? 33c9 c705????????51000000 ff15???????? }
            // n = 7, score = 100
            //   4c8bc3               | dec                 eax
            //   33d2                 | lea                 eax, [0xd356]
            //   488bc8               | mov                 byte ptr [ecx + 0x10], 0
            //   e8????????           |                     
            //   33c9                 | inc                 ecx
            //   c705????????51000000     |     
            //   ff15????????         |                     

        $sequence_13 = { e8???????? 4885c0 752f 488d0dbac80100 8bd7 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   4885c0               | dec                 eax
            //   752f                 | add                 edx, eax
            //   488d0dbac80100       | dec                 eax
            //   8bd7                 | mov                 eax, dword ptr [esp + 0x48]

        $sequence_14 = { 483305???????? 488bcb 488905???????? ff15???????? 488d1571c10000 483305???????? 488bcb }
            // n = 7, score = 100
            //   483305????????       |                     
            //   488bcb               | mov                 edx, esi
            //   488905????????       |                     
            //   ff15????????         |                     
            //   488d1571c10000       | inc                 esp
            //   483305????????       |                     
            //   488bcb               | lea                 eax, [edx + 0xa]

        $sequence_15 = { 0f1f4000 0fb6440d07 48ffc1 324415f7 4883f90f 490f44ce }
            // n = 6, score = 100
            //   0f1f4000             | inc                 eax
            //   0fb6440d07           | push                ebx
            //   48ffc1               | dec                 eax
            //   324415f7             | sub                 esp, 0x20
            //   4883f90f             | dec                 eax
            //   490f44ce             | and                 dword ptr [ecx + 8], 0

    condition:
        7 of them and filesize < 557056
}