rule win_tonedeaf_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.tonedeaf."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tonedeaf"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c0 660fd645d4 33db 8945d8 895dd4 }
            // n = 5, score = 400
            //   33c0                 | xor                 eax, eax
            //   660fd645d4           | movq                qword ptr [ebp - 0x2c], xmm0
            //   33db                 | xor                 ebx, ebx
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   895dd4               | mov                 dword ptr [ebp - 0x2c], ebx

        $sequence_1 = { 8b5004 8d4af8 898c153cffffff 8d45a8 c745fc01000000 }
            // n = 5, score = 400
            //   8b5004               | mov                 edx, dword ptr [eax + 4]
            //   8d4af8               | lea                 ecx, [edx - 8]
            //   898c153cffffff       | mov                 dword ptr [ebp + edx - 0xc4], ecx
            //   8d45a8               | lea                 eax, [ebp - 0x58]
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1

        $sequence_2 = { 33db 8945d8 895dd4 8945dc }
            // n = 4, score = 400
            //   33db                 | xor                 ebx, ebx
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   895dd4               | mov                 dword ptr [ebp - 0x2c], ebx
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax

        $sequence_3 = { 75f3 8bf3 8a03 43 }
            // n = 4, score = 400
            //   75f3                 | jne                 0xfffffff5
            //   8bf3                 | mov                 esi, ebx
            //   8a03                 | mov                 al, byte ptr [ebx]
            //   43                   | inc                 ebx

        $sequence_4 = { 50 6a01 6a6b 57 ff15???????? }
            // n = 5, score = 400
            //   50                   | push                eax
            //   6a01                 | push                1
            //   6a6b                 | push                0x6b
            //   57                   | push                edi
            //   ff15????????         |                     

        $sequence_5 = { 50 6a01 6a6b 57 }
            // n = 4, score = 400
            //   50                   | push                eax
            //   6a01                 | push                1
            //   6a6b                 | push                0x6b
            //   57                   | push                edi

        $sequence_6 = { 8d7601 884c32ff 84c9 75f3 8bf3 }
            // n = 5, score = 400
            //   8d7601               | lea                 esi, [esi + 1]
            //   884c32ff             | mov                 byte ptr [edx + esi - 1], cl
            //   84c9                 | test                cl, cl
            //   75f3                 | jne                 0xfffffff5
            //   8bf3                 | mov                 esi, ebx

        $sequence_7 = { 0f57c0 c745dc00000000 33c0 660fd645d4 33db 8945d8 }
            // n = 6, score = 400
            //   0f57c0               | xorps               xmm0, xmm0
            //   c745dc00000000       | mov                 dword ptr [ebp - 0x24], 0
            //   33c0                 | xor                 eax, eax
            //   660fd645d4           | movq                qword ptr [ebp - 0x2c], xmm0
            //   33db                 | xor                 ebx, ebx
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax

        $sequence_8 = { 0f57c0 c745dc00000000 33c0 660fd645d4 33db 8945d8 895dd4 }
            // n = 7, score = 400
            //   0f57c0               | xorps               xmm0, xmm0
            //   c745dc00000000       | mov                 dword ptr [ebp - 0x24], 0
            //   33c0                 | xor                 eax, eax
            //   660fd645d4           | movq                qword ptr [ebp - 0x2c], xmm0
            //   33db                 | xor                 ebx, ebx
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   895dd4               | mov                 dword ptr [ebp - 0x2c], ebx

        $sequence_9 = { 2bc6 83f801 732f 8b0f 8bc1 2bc6 48 }
            // n = 7, score = 400
            //   2bc6                 | sub                 eax, esi
            //   83f801               | cmp                 eax, 1
            //   732f                 | jae                 0x31
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   8bc1                 | mov                 eax, ecx
            //   2bc6                 | sub                 eax, esi
            //   48                   | dec                 eax

    condition:
        7 of them and filesize < 851968
}