rule win_torisma_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.torisma."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.torisma"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7402 eb05 e9???????? b833280000 }
            // n = 4, score = 200
            //   7402                 | je                  4
            //   eb05                 | jmp                 7
            //   e9????????           |                     
            //   b833280000           | mov                 eax, 0x2833

        $sequence_1 = { e8???????? 3d514b0000 7504 33c0 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   3d514b0000           | cmp                 eax, 0x4b51
            //   7504                 | jne                 6
            //   33c0                 | xor                 eax, eax

        $sequence_2 = { e8???????? 3d83490000 7507 b883490000 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   3d83490000           | cmp                 eax, 0x4983
            //   7507                 | jne                 9
            //   b883490000           | mov                 eax, 0x4983

        $sequence_3 = { 4889442458 488b442458 4889442430 488b4c2430 e8???????? }
            // n = 5, score = 100
            //   4889442458           | dec                 eax
            //   488b442458           | mov                 dword ptr [esp + 0x58], eax
            //   4889442430           | dec                 eax
            //   488b4c2430           | mov                 eax, dword ptr [esp + 0x58]
            //   e8????????           |                     

        $sequence_4 = { 50 ff15???????? 8b4dfc 51 6a40 ff15???????? 8945f8 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   51                   | push                ecx
            //   6a40                 | push                0x40
            //   ff15????????         |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

        $sequence_5 = { c1e91b 83e101 33d1 8b4508 8b4878 }
            // n = 5, score = 100
            //   c1e91b               | shr                 ecx, 0x1b
            //   83e101               | and                 ecx, 1
            //   33d1                 | xor                 edx, ecx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b4878               | mov                 ecx, dword ptr [eax + 0x78]

        $sequence_6 = { 8b55f4 52 8b4da4 e8???????? }
            // n = 4, score = 100
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   52                   | push                edx
            //   8b4da4               | mov                 ecx, dword ptr [ebp - 0x5c]
            //   e8????????           |                     

        $sequence_7 = { 83e101 c1e102 8b9424bc000000 0bd1 }
            // n = 4, score = 100
            //   83e101               | and                 ecx, 1
            //   c1e102               | shl                 ecx, 2
            //   8b9424bc000000       | mov                 edx, dword ptr [esp + 0xbc]
            //   0bd1                 | or                  edx, ecx

        $sequence_8 = { 837c246800 740a 8b442430 89442438 eb08 }
            // n = 5, score = 100
            //   837c246800           | and                 eax, 1
            //   740a                 | dec                 eax
            //   8b442430             | mov                 dword ptr [esp + 8], ecx
            //   89442438             | push                edi
            //   eb08                 | dec                 eax

        $sequence_9 = { 89442430 488b442450 8b404c 83e001 }
            // n = 4, score = 100
            //   89442430             | dec                 eax
            //   488b442450           | mov                 dword ptr [esp + 0x30], eax
            //   8b404c               | dec                 eax
            //   83e001               | mov                 ecx, dword ptr [esp + 0x30]

        $sequence_10 = { 817df404810200 760a b8514b0000 e9???????? 8b45f4 }
            // n = 5, score = 100
            //   817df404810200       | cmp                 dword ptr [ebp - 0xc], 0x28104
            //   760a                 | jbe                 0xc
            //   b8514b0000           | mov                 eax, 0x4b51
            //   e9????????           |                     
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

        $sequence_11 = { b862000000 668945d2 b962000000 66894dd4 ba30000000 }
            // n = 5, score = 100
            //   b862000000           | mov                 eax, 0x62
            //   668945d2             | mov                 word ptr [ebp - 0x2e], ax
            //   b962000000           | mov                 ecx, 0x62
            //   66894dd4             | mov                 word ptr [ebp - 0x2c], cx
            //   ba30000000           | mov                 edx, 0x30

        $sequence_12 = { 48894c2408 57 4881ecb0000000 48c7842488000000feffffff }
            // n = 4, score = 100
            //   48894c2408           | mov                 dword ptr [esp + 0x30], eax
            //   57                   | dec                 eax
            //   4881ecb0000000       | mov                 eax, dword ptr [esp + 0x50]
            //   48c7842488000000feffffff     | mov    eax, dword ptr [eax + 0x4c]

    condition:
        7 of them and filesize < 322560
}