rule win_trickbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.trickbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.trickbot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f7d8 1bc0 83e002 83c002 eb0d }
            // n = 5, score = 4500
            //   f7d8                 | neg                 eax
            //   1bc0                 | sbb                 eax, eax
            //   83e002               | and                 eax, 2
            //   83c002               | add                 eax, 2
            //   eb0d                 | jmp                 0xf

        $sequence_1 = { 83c002 eb0d 2500000080 f7d8 1bc0 83e007 40 }
            // n = 7, score = 4500
            //   83c002               | add                 eax, 2
            //   eb0d                 | jmp                 0xf
            //   2500000080           | and                 eax, 0x80000000
            //   f7d8                 | neg                 eax
            //   1bc0                 | sbb                 eax, eax
            //   83e007               | and                 eax, 7
            //   40                   | inc                 eax

        $sequence_2 = { 83e020 83c020 eb36 2500000080 f7d8 1bc0 }
            // n = 6, score = 4500
            //   83e020               | and                 eax, 0x20
            //   83c020               | add                 eax, 0x20
            //   eb36                 | jmp                 0x38
            //   2500000080           | and                 eax, 0x80000000
            //   f7d8                 | neg                 eax
            //   1bc0                 | sbb                 eax, eax

        $sequence_3 = { a900000020 7429 a900000040 7411 }
            // n = 4, score = 4500
            //   a900000020           | test                eax, 0x20000000
            //   7429                 | je                  0x2b
            //   a900000040           | test                eax, 0x40000000
            //   7411                 | je                  0x13

        $sequence_4 = { 1bc0 83e070 83c010 eb25 a900000040 7411 2500000080 }
            // n = 7, score = 4500
            //   1bc0                 | sbb                 eax, eax
            //   83e070               | and                 eax, 0x70
            //   83c010               | add                 eax, 0x10
            //   eb25                 | jmp                 0x27
            //   a900000040           | test                eax, 0x40000000
            //   7411                 | je                  0x13
            //   2500000080           | and                 eax, 0x80000000

        $sequence_5 = { 7411 2500000080 f7d8 1bc0 83e020 83c020 eb36 }
            // n = 7, score = 4500
            //   7411                 | je                  0x13
            //   2500000080           | and                 eax, 0x80000000
            //   f7d8                 | neg                 eax
            //   1bc0                 | sbb                 eax, eax
            //   83e020               | and                 eax, 0x20
            //   83c020               | add                 eax, 0x20
            //   eb36                 | jmp                 0x38

        $sequence_6 = { c705????????fdffffff c705????????feffffff c705????????ffffffff e8???????? }
            // n = 4, score = 3700
            //   c705????????fdffffff     |     
            //   c705????????feffffff     |     
            //   c705????????ffffffff     |     
            //   e8????????           |                     

        $sequence_7 = { 83c724 8b07 a900000020 7429 }
            // n = 4, score = 3700
            //   83c724               | add                 edi, 0x24
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   a900000020           | test                eax, 0x20000000
            //   7429                 | je                  0x2b

        $sequence_8 = { 895df8 895df4 895dec 66c745f00005 }
            // n = 4, score = 3500
            //   895df8               | mov                 eax, dword ptr [ecx + 0x48]
            //   895df4               | dec                 eax
            //   895dec               | mov                 dword ptr [esp + 0x38], eax
            //   66c745f00005         | dec                 eax

        $sequence_9 = { 7420 3d7f000004 7419 3d7f000005 7412 3d7f000006 740b }
            // n = 7, score = 3400
            //   7420                 | dec                 eax
            //   3d7f000004           | mov                 edx, dword ptr [ecx + 0x18]
            //   7419                 | dec                 eax
            //   3d7f000005           | mov                 dword ptr [esp + 0x38], eax
            //   7412                 | dec                 eax
            //   3d7f000006           | mov                 eax, dword ptr [ecx + 0x40]
            //   740b                 | dec                 esp

        $sequence_10 = { 8b45fc 8d1489 8d0cd0 8b4114 2b410c }
            // n = 5, score = 3000
            //   8b45fc               | sbb                 eax, eax
            //   8d1489               | and                 eax, 0x70
            //   8d0cd0               | add                 eax, 0x10
            //   8b4114               | jmp                 0x36
            //   2b410c               | jmp                 0x27

        $sequence_11 = { 488b01 4c8b4120 488b5118 488b4910 ffd0 }
            // n = 5, score = 2800
            //   488b01               | dec                 eax
            //   4c8b4120             | mov                 eax, dword ptr [ecx + 0x40]
            //   488b5118             | dec                 eax
            //   488b4910             | mov                 dword ptr [esp + 0x30], eax
            //   ffd0                 | dec                 eax

        $sequence_12 = { 488b4148 4889442438 488b4140 4889442430 488b4138 4889442428 488b4130 }
            // n = 7, score = 2800
            //   488b4148             | dec                 eax
            //   4889442438           | mov                 eax, dword ptr [ecx + 0x48]
            //   488b4140             | dec                 eax
            //   4889442430           | mov                 dword ptr [esp + 0x38], eax
            //   488b4138             | dec                 eax
            //   4889442428           | mov                 eax, dword ptr [ecx + 0x40]
            //   488b4130             | dec                 eax

        $sequence_13 = { 488b5118 4889442440 488b4148 4889442438 }
            // n = 4, score = 2800
            //   488b5118             | dec                 eax
            //   4889442440           | mov                 eax, dword ptr [ecx + 0x48]
            //   488b4148             | dec                 eax
            //   4889442438           | mov                 dword ptr [esp + 0x38], eax

        $sequence_14 = { 4c8b4928 4c8b4120 488b5118 4889442438 488b4140 4889442430 }
            // n = 6, score = 2800
            //   4c8b4928             | mov                 eax, dword ptr [ecx + 0x40]
            //   4c8b4120             | dec                 eax
            //   488b5118             | mov                 dword ptr [esp + 0x30], eax
            //   4889442438           | dec                 eax
            //   488b4140             | mov                 eax, dword ptr [ecx + 0x38]
            //   4889442430           | dec                 eax

        $sequence_15 = { 488b4138 4889442428 488b4130 488b4910 4889442420 41ffd2 }
            // n = 6, score = 2800
            //   488b4138             | mov                 ecx, dword ptr [ecx + 0x10]
            //   4889442428           | dec                 eax
            //   488b4130             | mov                 dword ptr [esp + 0x40], eax
            //   488b4910             | dec                 eax
            //   4889442420           | mov                 eax, dword ptr [ecx + 0x48]
            //   41ffd2               | dec                 eax

        $sequence_16 = { 488b4150 4c8b11 4c8b4928 4c8b4120 488b5118 4889442440 }
            // n = 6, score = 2800
            //   488b4150             | mov                 edx, dword ptr [ecx + 0x18]
            //   4c8b11               | dec                 eax
            //   4c8b4928             | mov                 dword ptr [esp + 0x40], eax
            //   4c8b4120             | dec                 eax
            //   488b5118             | mov                 eax, dword ptr [ecx + 0x48]
            //   4889442440           | dec                 eax

        $sequence_17 = { 48397c2430 0f94c3 8bc3 488b5c2450 }
            // n = 4, score = 2500
            //   48397c2430           | add                 eax, 0x20
            //   0f94c3               | jmp                 0x38
            //   8bc3                 | and                 eax, 0x80000000
            //   488b5c2450           | neg                 eax

        $sequence_18 = { 488d4c2450 4533c9 4533c0 ff15???????? 85c0 }
            // n = 5, score = 2100
            //   488d4c2450           | dec                 eax
            //   4533c9               | mov                 ecx, dword ptr [ecx + 0x10]
            //   4533c0               | dec                 eax
            //   ff15????????         |                     
            //   85c0                 | mov                 dword ptr [esp + 0x20], eax

        $sequence_19 = { 897710 488b742438 488bc7 4883c420 }
            // n = 4, score = 2100
            //   897710               | dec                 eax
            //   488b742438           | mov                 ecx, dword ptr [ecx + 0x10]
            //   488bc7               | dec                 eax
            //   4883c420             | mov                 eax, dword ptr [ecx + 0x30]

        $sequence_20 = { d1e8 03c2 c1e806 6bc05f }
            // n = 4, score = 2000
            //   d1e8                 | mov                 dword ptr [esp + 0x30], eax
            //   03c2                 | dec                 eax
            //   c1e806               | mov                 eax, dword ptr [ecx + 0x38]
            //   6bc05f               | dec                 eax

        $sequence_21 = { 83780400 7404 8b4008 c3 }
            // n = 4, score = 2000
            //   83780400             | dec                 eax
            //   7404                 | mov                 eax, dword ptr [ecx]
            //   8b4008               | dec                 eax
            //   c3                   | mov                 edx, dword ptr [ecx + 0x18]

        $sequence_22 = { 6820bf0200 68905f0100 68905f0100 50 ff15???????? }
            // n = 5, score = 2000
            //   6820bf0200           | mov                 edx, dword ptr [ecx]
            //   68905f0100           | dec                 esp
            //   68905f0100           | mov                 ecx, dword ptr [ecx + 0x28]
            //   50                   | dec                 esp
            //   ff15????????         |                     

        $sequence_23 = { 51 68e9fd0000 50 e8???????? }
            // n = 4, score = 1800
            //   51                   | dec                 eax
            //   68e9fd0000           | mov                 ecx, dword ptr [ecx + 0x10]
            //   50                   | call                eax
            //   e8????????           |                     

        $sequence_24 = { 6a40 6800300000 6a70 6a00 }
            // n = 4, score = 1800
            //   6a40                 | dec                 eax
            //   6800300000           | mov                 dword ptr [esp + 0x30], eax
            //   6a70                 | dec                 eax
            //   6a00                 | mov                 eax, dword ptr [ecx + 0x38]

        $sequence_25 = { c3 6a01 ff15???????? 50 }
            // n = 4, score = 1500
            //   c3                   | ret                 
            //   6a01                 | push                1
            //   ff15????????         |                     
            //   50                   | push                eax

        $sequence_26 = { e8???????? 6a00 6a28 e8???????? }
            // n = 4, score = 1500
            //   e8????????           |                     
            //   6a00                 | mov                 eax, dword ptr [ecx + 0x30]
            //   6a28                 | dec                 eax
            //   e8????????           |                     

        $sequence_27 = { 8d440002 6a00 50 e8???????? }
            // n = 4, score = 1500
            //   8d440002             | dec                 eax
            //   6a00                 | mov                 dword ptr [esp + 0x28], eax
            //   50                   | dec                 eax
            //   e8????????           |                     

        $sequence_28 = { 8b01 59 03d0 52 }
            // n = 4, score = 1300
            //   8b01                 | and                 eax, 0x80000000
            //   59                   | neg                 eax
            //   03d0                 | sbb                 eax, eax
            //   52                   | and                 eax, 7

        $sequence_29 = { 03d0 52 ebdc 89450c }
            // n = 4, score = 1300
            //   03d0                 | jmp                 0x12
            //   52                   | and                 eax, 0x80000000
            //   ebdc                 | and                 eax, 0x70
            //   89450c               | add                 eax, 0x10

        $sequence_30 = { 488b01 488b4910 ffd0 ba01000000 }
            // n = 4, score = 1300
            //   488b01               | neg                 eax
            //   488b4910             | sbb                 eax, eax
            //   ffd0                 | and                 eax, 2
            //   ba01000000           | add                 eax, 2

        $sequence_31 = { 8bc1 66ad 85c0 741c }
            // n = 4, score = 1300
            //   8bc1                 | je                  0x1d
            //   66ad                 | and                 eax, 2
            //   85c0                 | add                 eax, 2
            //   741c                 | jmp                 0x12

        $sequence_32 = { 85c0 7f0b e8???????? 8b05???????? }
            // n = 4, score = 1300
            //   85c0                 | dec                 eax
            //   7f0b                 | mov                 edx, dword ptr [ecx + 0x18]
            //   e8????????           |                     
            //   8b05????????         |                     

        $sequence_33 = { e8???????? 83f801 7411 ba0a000000 }
            // n = 4, score = 1300
            //   e8????????           |                     
            //   83f801               | dec                 eax
            //   7411                 | mov                 eax, dword ptr [ecx + 0x48]
            //   ba0a000000           | dec                 esp

        $sequence_34 = { 50 8b450c ff4d0c ba28000000 f7e2 }
            // n = 5, score = 1200
            //   50                   | mov                 eax, dword ptr [ecx + 0x38]
            //   8b450c               | dec                 eax
            //   ff4d0c               | mov                 dword ptr [esp + 0x28], eax
            //   ba28000000           | dec                 eax
            //   f7e2                 | mov                 eax, dword ptr [ecx + 0x30]

        $sequence_35 = { c1e102 2bc1 8b00 894508 }
            // n = 4, score = 1200
            //   c1e102               | add                 eax, 0x10
            //   2bc1                 | jmp                 0x2f
            //   8b00                 | neg                 eax
            //   894508               | sbb                 eax, eax

        $sequence_36 = { 7405 e8???????? ff15???????? 8bc3 }
            // n = 4, score = 1200
            //   7405                 | mov                 edx, dword ptr [ecx]
            //   e8????????           |                     
            //   ff15????????         |                     
            //   8bc3                 | dec                 esp

        $sequence_37 = { 741c 3bc1 7213 2bc1 }
            // n = 4, score = 1200
            //   741c                 | and                 eax, 0x80000000
            //   3bc1                 | neg                 eax
            //   7213                 | sbb                 eax, eax
            //   2bc1                 | and                 eax, 0x70

        $sequence_38 = { 59 ff5508 58 894514 8b5510 }
            // n = 5, score = 1100
            //   59                   | mov                 dword ptr [esp + 0x38], eax
            //   ff5508               | dec                 eax
            //   58                   | mov                 eax, dword ptr [ecx + 0x40]
            //   894514               | dec                 eax
            //   8b5510               | mov                 dword ptr [esp + 0x30], eax

        $sequence_39 = { 2bc1 8b00 3bc7 72f2 }
            // n = 4, score = 1100
            //   2bc1                 | dec                 eax
            //   8b00                 | mov                 ecx, dword ptr [ecx + 0x10]
            //   3bc7                 | dec                 esp
            //   72f2                 | mov                 eax, dword ptr [ecx + 0x20]

        $sequence_40 = { ff5508 8b5510 8b4a04 ff5508 50 51 }
            // n = 6, score = 1100
            //   ff5508               | dec                 eax
            //   8b5510               | mov                 eax, dword ptr [ecx + 0x38]
            //   8b4a04               | dec                 eax
            //   ff5508               | mov                 dword ptr [esp + 0x28], eax
            //   50                   | dec                 eax
            //   51                   | mov                 dword ptr [esp + 0x40], eax

        $sequence_41 = { ba28000000 f7e2 8d9500040000 03d0 895510 }
            // n = 5, score = 1000
            //   ba28000000           | dec                 eax
            //   f7e2                 | mov                 edx, dword ptr [ecx + 0x18]
            //   8d9500040000         | dec                 eax
            //   03d0                 | mov                 ecx, dword ptr [ecx + 0x10]
            //   895510               | call                eax

        $sequence_42 = { 7911 8bc8 e8???????? bb10000000 }
            // n = 4, score = 900
            //   7911                 | test                eax, eax
            //   8bc8                 | je                  0x1e
            //   e8????????           |                     
            //   bb10000000           | cmp                 eax, ecx

        $sequence_43 = { 85c0 790f 8bc8 e8???????? 8d5e10 }
            // n = 5, score = 900
            //   85c0                 | mov                 eax, ecx
            //   790f                 | lodsw               ax, word ptr [esi]
            //   8bc8                 | test                eax, eax
            //   e8????????           |                     
            //   8d5e10               | je                  0x22

        $sequence_44 = { 8bcf e8???????? 8bf0 85ed }
            // n = 4, score = 900
            //   8bcf                 | dec                 eax
            //   e8????????           |                     
            //   8bf0                 | mov                 edx, dword ptr [ecx + 0x18]
            //   85ed                 | dec                 eax

        $sequence_45 = { 58 41 41 41 41 }
            // n = 5, score = 900
            //   58                   | cmp                 dword ptr [esp + 0x30], edi
            //   41                   | sete                bl
            //   41                   | mov                 eax, ebx
            //   41                   | dec                 eax
            //   41                   | mov                 ebx, dword ptr [esp + 0x50]

        $sequence_46 = { 8b8e88000000 85c9 7514 398e8c000000 }
            // n = 4, score = 900
            //   8b8e88000000         | push                edx
            //   85c9                 | jmp                 0xffffffe1
            //   7514                 | mov                 dword ptr [ebp + 0xc], eax
            //   398e8c000000         | mov                 eax, ebp

        $sequence_47 = { 666666660f1f840000000000 8b4728 8bd6 83f801 }
            // n = 4, score = 900
            //   666666660f1f840000000000     | je    0x20
            //   8b4728               | cmp                 eax, ecx
            //   8bd6                 | pop                 ecx
            //   83f801               | add                 edx, eax

        $sequence_48 = { c744242000001f00 ff15???????? 85c0 7911 }
            // n = 4, score = 900
            //   c744242000001f00     | sub                 eax, ecx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7911                 | je                  0x1e

        $sequence_49 = { 7536 b906000000 8bc1 c3 }
            // n = 4, score = 900
            //   7536                 | shl                 ecx, 2
            //   b906000000           | sub                 eax, ecx
            //   8bc1                 | mov                 eax, dword ptr [eax]
            //   c3                   | mov                 dword ptr [ebp + 8], eax

        $sequence_50 = { 3bd1 0f8293000000 038e8c000000 3bd1 }
            // n = 4, score = 900
            //   3bd1                 | cmp                 eax, ecx
            //   0f8293000000         | jb                  0x19
            //   038e8c000000         | sub                 eax, ecx
            //   3bd1                 | push                edx

        $sequence_51 = { b9e0000000 663bc1 740b b80b010000 }
            // n = 4, score = 900
            //   b9e0000000           | cmp                 eax, ecx
            //   663bc1               | je                  0x1e
            //   740b                 | cmp                 eax, ecx
            //   b80b010000           | jb                  0x17

        $sequence_52 = { ff15???????? 8bf0 c1ee1f 83f601 }
            // n = 4, score = 900
            //   ff15????????         |                     
            //   8bf0                 | mov                 ecx, dword ptr [ecx + 0x28]
            //   c1ee1f               | dec                 esp
            //   83f601               | mov                 eax, dword ptr [ecx + 0x20]

        $sequence_53 = { 41 50 2bc1 8b00 }
            // n = 4, score = 800
            //   41                   | mov                 ecx, dword ptr [ecx + 0x10]
            //   50                   | dec                 eax
            //   2bc1                 | mov                 dword ptr [esp + 0x20], eax
            //   8b00                 | inc                 ecx

        $sequence_54 = { 8bc8 33c0 85c9 0f95c0 eb02 33c0 }
            // n = 6, score = 800
            //   8bc8                 | mov                 dword ptr [esp + 0x38], eax
            //   33c0                 | dec                 eax
            //   85c9                 | mov                 eax, dword ptr [ecx + 0x40]
            //   0f95c0               | dec                 eax
            //   eb02                 | mov                 dword ptr [esp + 0x30], eax
            //   33c0                 | dec                 eax

        $sequence_55 = { 50 e2fd 8bc7 57 8bec }
            // n = 5, score = 700
            //   50                   | test                eax, 0x40000000
            //   e2fd                 | je                  0x18
            //   8bc7                 | and                 eax, 0x80000000
            //   57                   | neg                 eax
            //   8bec                 | sbb                 eax, eax

        $sequence_56 = { 894504 68f0ff0000 59 8bf7 8bd7 }
            // n = 5, score = 700
            //   894504               | neg                 eax
            //   68f0ff0000           | sbb                 eax, eax
            //   59                   | and                 eax, 2
            //   8bf7                 | neg                 eax
            //   8bd7                 | sbb                 eax, eax

        $sequence_57 = { 8bc7 e8???????? 85c0 0f849f000000 }
            // n = 4, score = 700
            //   8bc7                 | dec                 eax
            //   e8????????           |                     
            //   85c0                 | mov                 edx, dword ptr [ecx + 0x18]
            //   0f849f000000         | dec                 eax

        $sequence_58 = { 8bf7 8bd7 fc 8bc1 }
            // n = 4, score = 700
            //   8bf7                 | jmp                 0x17
            //   8bd7                 | and                 eax, 0x80000000
            //   fc                   | jmp                 0x38
            //   8bc1                 | and                 eax, 0x80000000

        $sequence_59 = { 8b7d10 2bf9 53 50 }
            // n = 4, score = 200
            //   8b7d10               | jb                  0x17
            //   2bf9                 | sub                 eax, ecx
            //   53                   | mov                 eax, ecx
            //   50                   | lodsw               ax, word ptr [esi]

        $sequence_60 = { ff15???????? 6a00 6a00 6a00 8d45dc 50 ff15???????? }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   6a00                 | add                 edx, eax
            //   6a00                 | push                edx
            //   6a00                 | jmp                 0xffffffdf
            //   8d45dc               | mov                 eax, dword ptr [ecx]
            //   50                   | pop                 ecx
            //   ff15????????         |                     

        $sequence_61 = { 8dbf00500310 8bd6 897d08 3bc8 }
            // n = 4, score = 200
            //   8dbf00500310         | lodsw               ax, word ptr [esi]
            //   8bd6                 | test                eax, eax
            //   897d08               | je                  0x20
            //   3bc8                 | cmp                 eax, ecx

        $sequence_62 = { c745d000500000 817dd000100000 760b 8b45d0 83e801 }
            // n = 5, score = 100
            //   c745d000500000       | mov                 dword ptr [esp + 0x30], eax
            //   817dd000100000       | dec                 eax
            //   760b                 | mov                 eax, dword ptr [ecx + 0x38]
            //   8b45d0               | dec                 eax
            //   83e801               | mov                 dword ptr [esp + 0x28], eax

        $sequence_63 = { c745cc00000000 6a00 685b020000 6a00 }
            // n = 4, score = 100
            //   c745cc00000000       | mov                 eax, dword ptr [ecx + 0x40]
            //   6a00                 | dec                 eax
            //   685b020000           | mov                 dword ptr [esp + 0x30], eax
            //   6a00                 | dec                 eax

        $sequence_64 = { 01dd f361 34aa 61 34aa }
            // n = 5, score = 100
            //   01dd                 | je                  0x18
            //   f361                 | and                 eax, 0x80000000
            //   34aa                 | neg                 eax
            //   61                   | sbb                 eax, eax
            //   34aa                 | and                 eax, 0x20

        $sequence_65 = { e8???????? 8d7de0 e8???????? 8b4dfc }
            // n = 4, score = 100
            //   e8????????           |                     
            //   8d7de0               | and                 eax, 0x80000000
            //   e8????????           |                     
            //   8b4dfc               | and                 eax, 0x70

        $sequence_66 = { 8bec 56 ff750c 6818280300 }
            // n = 4, score = 100
            //   8bec                 | test                eax, eax
            //   56                   | je                  0x20
            //   ff750c               | cmp                 eax, ecx
            //   6818280300           | jb                  0x17

        $sequence_67 = { 033d???????? 33c7 8d3c0e 2b75f8 33c7 2bd0 }
            // n = 6, score = 100
            //   033d????????         |                     
            //   33c7                 | add                 eax, 0x20
            //   8d3c0e               | jmp                 0x3b
            //   2b75f8               | and                 eax, 0x80000000
            //   33c7                 | neg                 eax
            //   2bd0                 | and                 eax, 0x20

        $sequence_68 = { 83f83c 762a 56 e8???????? 8d044584030101 }
            // n = 5, score = 100
            //   83f83c               | and                 eax, 0x20
            //   762a                 | add                 eax, 0x20
            //   56                   | jmp                 0x3b
            //   e8????????           |                     
            //   8d044584030101       | and                 eax, 0x80000000

        $sequence_69 = { 8b45fc 8945c8 8b45d0 40 8945d0 ff75fc }
            // n = 6, score = 100
            //   8b45fc               | cmp                 eax, ecx
            //   8945c8               | jb                  0x19
            //   8b45d0               | je                  0x1e
            //   40                   | cmp                 eax, ecx
            //   8945d0               | jb                  0x15
            //   ff75fc               | sub                 eax, ecx

        $sequence_70 = { 3d00010000 7d10 8a8c181d010000 888800f80001 40 ebe6 ff35???????? }
            // n = 7, score = 100
            //   3d00010000           | and                 eax, 0x70
            //   7d10                 | add                 eax, 0x10
            //   8a8c181d010000       | jmp                 0x2a
            //   888800f80001         | test                eax, 0x40000000
            //   40                   | and                 eax, 0x70
            //   ebe6                 | add                 eax, 0x10
            //   ff35????????         |                     

        $sequence_71 = { 51 03cf 51 58 8910 59 5a }
            // n = 7, score = 100
            //   51                   | test                eax, eax
            //   03cf                 | je                  0x20
            //   51                   | cmp                 eax, ecx
            //   58                   | jb                  0x1b
            //   8910                 | lodsw               ax, word ptr [esi]
            //   59                   | test                eax, eax
            //   5a                   | je                  0x1e

        $sequence_72 = { ff75fc ff75d0 e8???????? 8b45d0 48 }
            // n = 5, score = 100
            //   ff75fc               | mov                 eax, ecx
            //   ff75d0               | lodsw               ax, word ptr [esi]
            //   e8????????           |                     
            //   8b45d0               | test                eax, eax
            //   48                   | je                  0x22

        $sequence_73 = { 8b4dd0 51 6800300400 8b55f8 52 ff15???????? }
            // n = 6, score = 100
            //   8b4dd0               | dec                 eax
            //   51                   | mov                 dword ptr [esp + 0x28], eax
            //   6800300400           | dec                 eax
            //   8b55f8               | mov                 eax, dword ptr [ecx + 0x30]
            //   52                   | dec                 eax
            //   ff15????????         |                     

        $sequence_74 = { 83e0fc 03c1 be???????? 8dbf00500310 8bd6 }
            // n = 5, score = 100
            //   83e0fc               | jb                  0x1b
            //   03c1                 | sub                 eax, ecx
            //   be????????           |                     
            //   8dbf00500310         | mov                 eax, ecx
            //   8bd6                 | lodsw               ax, word ptr [esi]

        $sequence_75 = { ff2495701b0001 8bc7 ba03000000 83e904 }
            // n = 4, score = 100
            //   ff2495701b0001       | jmp                 0x2a
            //   8bc7                 | test                eax, 0x40000000
            //   ba03000000           | je                  0x1d
            //   83e904               | and                 eax, 0x70

        $sequence_76 = { c705????????fc6c0001 c705????????ec630001 c705????????4e630001 c705????????da620001 c3 8bff 55 }
            // n = 7, score = 100
            //   c705????????fc6c0001     |     
            //   c705????????ec630001     |     
            //   c705????????4e630001     |     
            //   c705????????da620001     |     
            //   c3                   | neg                 eax
            //   8bff                 | sbb                 eax, eax
            //   55                   | and                 eax, 0x70

        $sequence_77 = { 12f7 5d 12f7 d93c8c }
            // n = 4, score = 100
            //   12f7                 | add                 eax, 0x10
            //   5d                   | jmp                 0x27
            //   12f7                 | test                eax, 0x40000000
            //   d93c8c               | je                  0x13

        $sequence_78 = { 7502 eb0c 8d55dc 52 ff15???????? ebcc c745f800000000 }
            // n = 7, score = 100
            //   7502                 | mov                 ecx, dword ptr [ecx + 0x10]
            //   eb0c                 | dec                 eax
            //   8d55dc               | mov                 dword ptr [esp + 0x20], eax
            //   52                   | dec                 eax
            //   ff15????????         |                     
            //   ebcc                 | mov                 eax, dword ptr [ecx + 0x40]
            //   c745f800000000       | dec                 eax

    condition:
        7 of them and filesize < 712704
}