rule win_unidentified_045_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_045."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_045"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 03480c 894f0c 395808 7517 ff7638 }
            // n = 5, score = 100
            //   03480c               | add                 ecx, dword ptr [eax + 0xc]
            //   894f0c               | mov                 dword ptr [edi + 0xc], ecx
            //   395808               | cmp                 dword ptr [eax + 8], ebx
            //   7517                 | jne                 0x19
            //   ff7638               | push                dword ptr [esi + 0x38]

        $sequence_1 = { 53 56 57 be04010000 56 33db 8d85f8fdffff }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   be04010000           | mov                 esi, 0x104
            //   56                   | push                esi
            //   33db                 | xor                 ebx, ebx
            //   8d85f8fdffff         | lea                 eax, [ebp - 0x208]

        $sequence_2 = { 5a 32040a 4a 83fa01 }
            // n = 4, score = 100
            //   5a                   | pop                 edx
            //   32040a               | xor                 al, byte ptr [edx + ecx]
            //   4a                   | dec                 edx
            //   83fa01               | cmp                 edx, 1

        $sequence_3 = { 8d85fcfeffff 50 e8???????? 83f801 74e1 68???????? ff15???????? }
            // n = 7, score = 100
            //   8d85fcfeffff         | lea                 eax, [ebp - 0x104]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83f801               | cmp                 eax, 1
            //   74e1                 | je                  0xffffffe3
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_4 = { 8d75ec e8???????? 85c0 0f8492000000 }
            // n = 4, score = 100
            //   8d75ec               | lea                 esi, [ebp - 0x14]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8492000000         | je                  0x98

        $sequence_5 = { 53 ff36 68???????? 53 53 ffd7 }
            // n = 6, score = 100
            //   53                   | push                ebx
            //   ff36                 | push                dword ptr [esi]
            //   68????????           |                     
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   ffd7                 | call                edi

        $sequence_6 = { 6a50 ff15???????? 8b3d???????? 8d7520 385d20 }
            // n = 5, score = 100
            //   6a50                 | push                0x50
            //   ff15????????         |                     
            //   8b3d????????         |                     
            //   8d7520               | lea                 esi, [ebp + 0x20]
            //   385d20               | cmp                 byte ptr [ebp + 0x20], bl

        $sequence_7 = { c70083c404e9 8b45fc c740046f92feff 8b45d8 8b400c }
            // n = 5, score = 100
            //   c70083c404e9         | mov                 dword ptr [eax], 0xe904c483
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   c740046f92feff       | mov                 dword ptr [eax + 4], 0xfffe926f
            //   8b45d8               | mov                 eax, dword ptr [ebp - 0x28]
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]

    condition:
        7 of them and filesize < 73728
}