rule win_unidentified_069_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_069."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_069"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8bf8 83c428 83ffff 7428 8d041f }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   83c428               | add                 esp, 0x28
            //   83ffff               | cmp                 edi, -1
            //   7428                 | je                  0x2a
            //   8d041f               | lea                 eax, [edi + ebx]

        $sequence_1 = { 8bc6 c1e710 e8???????? 0fb7c0 0bc7 8945cc }
            // n = 6, score = 100
            //   8bc6                 | mov                 eax, esi
            //   c1e710               | shl                 edi, 0x10
            //   e8????????           |                     
            //   0fb7c0               | movzx               eax, ax
            //   0bc7                 | or                  eax, edi
            //   8945cc               | mov                 dword ptr [ebp - 0x34], eax

        $sequence_2 = { 8b4514 5f 85c0 7402 8930 e8???????? 33c0 }
            // n = 7, score = 100
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   5f                   | pop                 edi
            //   85c0                 | test                eax, eax
            //   7402                 | je                  4
            //   8930                 | mov                 dword ptr [eax], esi
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { 46 3bf2 72c2 5f 5e 33c0 66890451 }
            // n = 7, score = 100
            //   46                   | inc                 esi
            //   3bf2                 | cmp                 esi, edx
            //   72c2                 | jb                  0xffffffc4
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   33c0                 | xor                 eax, eax
            //   66890451             | mov                 word ptr [ecx + edx*2], ax

        $sequence_4 = { 8d55e0 894df4 e8???????? 897dfc 66393d???????? 0f8487000000 53 }
            // n = 7, score = 100
            //   8d55e0               | lea                 edx, [ebp - 0x20]
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx
            //   e8????????           |                     
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   66393d????????       |                     
            //   0f8487000000         | je                  0x8d
            //   53                   | push                ebx

        $sequence_5 = { 837e2421 c645fa00 722d 6a0e 8d7dc0 }
            // n = 5, score = 100
            //   837e2421             | cmp                 dword ptr [esi + 0x24], 0x21
            //   c645fa00             | mov                 byte ptr [ebp - 6], 0
            //   722d                 | jb                  0x2f
            //   6a0e                 | push                0xe
            //   8d7dc0               | lea                 edi, [ebp - 0x40]

        $sequence_6 = { 85d2 741a 8d4618 8b08 85c9 7611 50 }
            // n = 7, score = 100
            //   85d2                 | test                edx, edx
            //   741a                 | je                  0x1c
            //   8d4618               | lea                 eax, [esi + 0x18]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   85c9                 | test                ecx, ecx
            //   7611                 | jbe                 0x13
            //   50                   | push                eax

        $sequence_7 = { 85f6 7628 57 8d7c3602 85ff 741e 8bc7 }
            // n = 7, score = 100
            //   85f6                 | test                esi, esi
            //   7628                 | jbe                 0x2a
            //   57                   | push                edi
            //   8d7c3602             | lea                 edi, [esi + esi + 2]
            //   85ff                 | test                edi, edi
            //   741e                 | je                  0x20
            //   8bc7                 | mov                 eax, edi

        $sequence_8 = { 8b44242c e8???????? 83671800 83671c00 68???????? 68???????? ff7510 }
            // n = 7, score = 100
            //   8b44242c             | mov                 eax, dword ptr [esp + 0x2c]
            //   e8????????           |                     
            //   83671800             | and                 dword ptr [edi + 0x18], 0
            //   83671c00             | and                 dword ptr [edi + 0x1c], 0
            //   68????????           |                     
            //   68????????           |                     
            //   ff7510               | push                dword ptr [ebp + 0x10]

        $sequence_9 = { 8d856cfeffff 50 e8???????? 8bcf 899de0fdffff }
            // n = 5, score = 100
            //   8d856cfeffff         | lea                 eax, [ebp - 0x194]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bcf                 | mov                 ecx, edi
            //   899de0fdffff         | mov                 dword ptr [ebp - 0x220], ebx

    condition:
        7 of them and filesize < 434176
}