rule win_unidentified_070_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_070."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_070"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 6a00 6a04 50 ff15???????? 8945fc }
            // n = 6, score = 300
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a04                 | push                4
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_1 = { 6a00 6a00 6a00 6a04 50 ff15???????? 8945fc }
            // n = 7, score = 300
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a04                 | push                4
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_2 = { 6a00 6a00 6a04 50 ff15???????? 8945fc 85c0 }
            // n = 7, score = 300
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a04                 | push                4
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   85c0                 | test                eax, eax

        $sequence_3 = { 6a04 50 ff15???????? 8945fc 85c0 }
            // n = 5, score = 300
            //   6a04                 | push                4
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   85c0                 | test                eax, eax

        $sequence_4 = { 6a00 6a04 50 ff15???????? 8945fc 85c0 }
            // n = 6, score = 300
            //   6a00                 | push                0
            //   6a04                 | push                4
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   85c0                 | test                eax, eax

        $sequence_5 = { 6a00 6a04 50 ff15???????? 8945fc }
            // n = 5, score = 300
            //   6a00                 | push                0
            //   6a04                 | push                4
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_6 = { 33c0 c20400 3b0d???????? 7502 }
            // n = 4, score = 300
            //   33c0                 | xor                 eax, eax
            //   c20400               | ret                 4
            //   3b0d????????         |                     
            //   7502                 | jne                 4

        $sequence_7 = { 85db 0f84af000000 6a00 6a00 }
            // n = 4, score = 200
            //   85db                 | test                ebx, ebx
            //   0f84af000000         | je                  0xb5
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_8 = { 742d 68???????? 57 ffd6 a3???????? 85c0 741c }
            // n = 7, score = 200
            //   742d                 | je                  0x2f
            //   68????????           |                     
            //   57                   | push                edi
            //   ffd6                 | call                esi
            //   a3????????           |                     
            //   85c0                 | test                eax, eax
            //   741c                 | je                  0x1e

        $sequence_9 = { 6808020000 8d8424d4020000 6a00 50 e8???????? }
            // n = 5, score = 200
            //   6808020000           | push                0x208
            //   8d8424d4020000       | lea                 eax, [esp + 0x2d4]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 90112
}