rule win_unidentified_091_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_091."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_091"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4d034360 488bd7 48c1ca27 4d03c1 4833d1 4c03c6 4d03e0 }
            // n = 7, score = 100
            //   4d034360             | mov                 ecx, ebx
            //   488bd7               | inc                 esp
            //   48c1ca27             | movaps              xmmword ptr [esp + 0xd0], xmm1
            //   4d03c1               | inc                 esp
            //   4833d1               | movaps              xmmword ptr [esp + 0xc0], xmm2
            //   4c03c6               | inc                 esp
            //   4d03e0               | movaps              xmmword ptr [esp + 0xb0], xmm3

        $sequence_1 = { e8???????? e9???????? c7442428f3050000 ba0a000000 41b999010000 e9???????? c7442428d9050000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   e9????????           |                     
            //   c7442428f3050000     | inc                 ecx
            //   ba0a000000           | mov                 eax, 0x348
            //   41b999010000         | dec                 eax
            //   e9????????           |                     
            //   c7442428d9050000     | lea                 edx, [0xdde77]

        $sequence_2 = { e8???????? 8b5340 8910 ff4304 e8???????? 41b800010000 488d55a0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b5340               | mov                 edx, dword ptr [ebx + 0xb8]
            //   8910                 | dec                 eax
            //   ff4304               | test                ecx, ecx
            //   e8????????           |                     
            //   41b800010000         | jne                 0xb33
            //   488d55a0             | inc                 esp

        $sequence_3 = { 85c0 7529 803e2c 7524 ba6b000000 c744242027020000 4c8d0d0cd81100 }
            // n = 7, score = 100
            //   85c0                 | dec                 eax
            //   7529                 | shr                 eax, 0x18
            //   803e2c               | movzx               ecx, byte ptr [edi + eax*4 + 0x223540]
            //   7524                 | inc                 ecx
            //   ba6b000000           | movzx               eax, cl
            //   c744242027020000     | inc                 ebp
            //   4c8d0d0cd81100       | mov                 ecx, dword ptr [edx + 8]

        $sequence_4 = { bf75000000 b85f000000 ba7b000000 89442420 4c8d0da9621100 448bc7 8d4a93 }
            // n = 7, score = 100
            //   bf75000000           | sub                 ecx, ecx
            //   b85f000000           | dec                 esp
            //   ba7b000000           | mov                 dword ptr [esp + 0x38], ebp
            //   89442420             | dec                 eax
            //   4c8d0da9621100       | add                 edx, eax
            //   448bc7               | dec                 ecx
            //   8d4a93               | cmp                 edx, eax

        $sequence_5 = { c1c007 8945ab 8b45db 4103c1 8bd0 33d6 c1c210 }
            // n = 7, score = 100
            //   c1c007               | dec                 eax
            //   8945ab               | cmovae              ecx, edx
            //   8b45db               | dec                 eax
            //   4103c1               | cmp                 ecx, ebx
            //   8bd0                 | dec                 eax
            //   33d6                 | add                 edx, ecx
            //   c1c210               | dec                 ecx

        $sequence_6 = { 723a 488b3b 488bd7 e8???????? 488d5601 4881fa00100000 7218 }
            // n = 7, score = 100
            //   723a                 | inc                 esp
            //   488b3b               | add                 ecx, dword ptr [ebp + ecx*4 - 0x19]
            //   488bd7               | mov                 ecx, edi
            //   e8????????           |                     
            //   488d5601             | inc                 ecx
            //   4881fa00100000       | xor                 edx, eax
            //   7218                 | inc                 esp

        $sequence_7 = { c3 53 e40d 00ade40d0048 e40d 00b8e40d0000 0303 }
            // n = 7, score = 100
            //   c3                   | mov                 ecx, 0xffffffff
            //   53                   | inc                 ecx
            //   e40d                 | movzx               eax, bh
            //   00ade40d0048         | shr                 al, 4
            //   e40d                 | and                 al, 3
            //   00b8e40d0000         | inc                 ecx
            //   0303                 | shl                 ah, 2

        $sequence_8 = { 8d48f0 488d1519641100 e8???????? 4885c0 7526 4c8d0d08641100 c744242025000000 }
            // n = 7, score = 100
            //   8d48f0               | mov                 byte ptr [esp + 0x20], cl
            //   488d1519641100       | dec                 esp
            //   e8????????           |                     
            //   4885c0               | lea                 eax, [ebp - 0x80]
            //   7526                 | dec                 eax
            //   4c8d0d08641100       | lea                 edx, [esp + 0x68]
            //   c744242025000000     | dec                 eax

        $sequence_9 = { 83f8ff 7407 4803c0 8954c608 89540d9f 488b75cf 4c8b6dd7 }
            // n = 7, score = 100
            //   83f8ff               | inc                 esp
            //   7407                 | movzx               eax, byte ptr [edx]
            //   4803c0               | inc                 ecx
            //   8954c608             | cmp                 al, 0x7f
            //   89540d9f             | inc                 edx
            //   488b75cf             | test                byte ptr [eax + edi + 0x10], 6
            //   4c8b6dd7             | jne                 0x413

    condition:
        7 of them and filesize < 5777408
}