rule win_unidentified_108_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_108."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_108"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d05c7580100 4a8b0ce8 42385cf938 7d4f 400fbece 4084f6 }
            // n = 6, score = 100
            //   488d05c7580100       | test                eax, eax
            //   4a8b0ce8             | je                  0x1014
            //   42385cf938           | dec                 esp
            //   7d4f                 | lea                 eax, [0xea8e]
            //   400fbece             | dec                 eax
            //   4084f6               | mov                 edi, ecx

        $sequence_1 = { 0f8493010000 488d2d3a100100 83635000 83632c00 e9???????? 48ff4318 837b2800 }
            // n = 7, score = 100
            //   0f8493010000         | inc                 ebp
            //   488d2d3a100100       | mov                 eax, ebp
            //   83635000             | dec                 esp
            //   83632c00             | mov                 ecx, eax
            //   e9????????           |                     
            //   48ff4318             | mov                 dword ptr [ebp + 0x18], ecx
            //   837b2800             | dec                 eax

        $sequence_2 = { 660feb0d???????? 4c8d0d44950000 f20f5cca f2410f590cc1 660f28d1 660f28c1 4c8d0d0b850000 }
            // n = 7, score = 100
            //   660feb0d????????     |                     
            //   4c8d0d44950000       | dec                 esp
            //   f20f5cca             | lea                 esi, [eax + eax*8]
            //   f2410f590cc1         | dec                 edx
            //   660f28d1             | mov                 ecx, dword ptr [ecx + eax*8]
            //   660f28c1             | dec                 ebp
            //   4c8d0d0b850000       | mov                 eax, ebp

        $sequence_3 = { 7426 488d5540 803201 488d5201 41ffc0 488d4540 498bcc }
            // n = 7, score = 100
            //   7426                 | mov                 al, byte ptr [ebx]
            //   488d5540             | dec                 ecx
            //   803201               | add                 ebx, eax
            //   488d5201             | dec                 ecx
            //   41ffc0               | mov                 ecx, dword ptr [esp + esi*8 + 0x1fcc0]
            //   488d4540             | mov                 byte ptr [ecx + edi*8 + 0x3b], al
            //   498bcc               | cmp                 edx, 3

        $sequence_4 = { 4c8d05a8310100 83e23f 488d14d2 498b04c0 f644d03801 }
            // n = 5, score = 100
            //   4c8d05a8310100       | lea                 edx, [0xf449]
            //   83e23f               | inc                 esp
            //   488d14d2             | mov                 byte ptr [ebx], al
            //   498b04c0             | dec                 eax
            //   f644d03801           | inc                 ebx

        $sequence_5 = { 488d1dd6db0100 458bc5 498bcc 48ffc1 4438040b 75f7 4885c9 }
            // n = 7, score = 100
            //   488d1dd6db0100       | dec                 eax
            //   458bc5               | lea                 edx, [ecx + 0x19920]
            //   498bcc               | dec                 eax
            //   48ffc1               | lea                 ecx, [ebp + 0x324]
            //   4438040b             | dec                 esp
            //   75f7                 | mov                 eax, esi
            //   4885c9               | dec                 eax

        $sequence_6 = { 458bc5 498bc4 90 48ffc0 44380401 }
            // n = 5, score = 100
            //   458bc5               | mov                 word ptr [esp + 0x88], ax
            //   498bc4               | mov                 word ptr [ebx], cx
            //   90                   | inc                 ebp
            //   48ffc0               | xor                 eax, eax
            //   44380401             | dec                 eax

        $sequence_7 = { 0fb6557f 4889451f 83f201 488d05dbc90000 49c1e302 4889452f 03d2 }
            // n = 7, score = 100
            //   0fb6557f             | inc                 ebp
            //   4889451f             | mov                 eax, ebp
            //   83f201               | dec                 eax
            //   488d05dbc90000       | cmp                 eax, ecx
            //   49c1e302             | jb                  0x4e
            //   4889452f             | dec                 eax
            //   03d2                 | lea                 ecx, [ebp + 0x20]

        $sequence_8 = { 488d9588000000 803201 488d5201 41ffc0 488d8588000000 }
            // n = 5, score = 100
            //   488d9588000000       | je                  0x1ec
            //   803201               | je                  0x4d1
            //   488d5201             | inc                 ebp
            //   41ffc0               | xor                 ecx, ecx
            //   488d8588000000       | inc                 esp

        $sequence_9 = { 7350 488bca 4c8d051d310100 83e13f 488bc2 48c1f806 }
            // n = 6, score = 100
            //   7350                 | mov                 eax, dword ptr [esp + 0x40]
            //   488bca               | dec                 eax
            //   4c8d051d310100       | lea                 edx, [0xee6c]
            //   83e13f               | inc                 esp
            //   488bc2               | mov                 bl, byte ptr [esp + 0xa0]
            //   48c1f806             | inc                 ecx

    condition:
        7 of them and filesize < 307200
}