rule win_virdetdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.virdetdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.virdetdoor"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 6a3d 33db 5f ff7508 8d041f 99 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   6a3d                 | push                0x3d
            //   33db                 | xor                 ebx, ebx
            //   5f                   | pop                 edi
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8d041f               | lea                 eax, [edi + ebx]
            //   99                   | cdq                 

        $sequence_1 = { 8bd7 53 8bce 8903 e8???????? 83c40c }
            // n = 6, score = 100
            //   8bd7                 | mov                 edx, edi
            //   53                   | push                ebx
            //   8bce                 | mov                 ecx, esi
            //   8903                 | mov                 dword ptr [ebx], eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_2 = { e8???????? 668b45ec 8b55f8 59 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   668b45ec             | mov                 ax, word ptr [ebp - 0x14]
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   59                   | pop                 ecx

        $sequence_3 = { 83ee01 753e 85ff 7524 390b 7720 }
            // n = 6, score = 100
            //   83ee01               | sub                 esi, 1
            //   753e                 | jne                 0x40
            //   85ff                 | test                edi, edi
            //   7524                 | jne                 0x26
            //   390b                 | cmp                 dword ptr [ebx], ecx
            //   7720                 | ja                  0x22

        $sequence_4 = { e8???????? ebe3 46 897508 3bb3b0020000 0f8cc1feffff eb13 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   ebe3                 | jmp                 0xffffffe5
            //   46                   | inc                 esi
            //   897508               | mov                 dword ptr [ebp + 8], esi
            //   3bb3b0020000         | cmp                 esi, dword ptr [ebx + 0x2b0]
            //   0f8cc1feffff         | jl                  0xfffffec7
            //   eb13                 | jmp                 0x15

        $sequence_5 = { 7514 81f980000000 720c 85d2 }
            // n = 4, score = 100
            //   7514                 | jne                 0x16
            //   81f980000000         | cmp                 ecx, 0x80
            //   720c                 | jb                  0xe
            //   85d2                 | test                edx, edx

        $sequence_6 = { 83feff 7424 6a00 6800100000 33d2 8bce }
            // n = 6, score = 100
            //   83feff               | cmp                 esi, -1
            //   7424                 | je                  0x26
            //   6a00                 | push                0
            //   6800100000           | push                0x1000
            //   33d2                 | xor                 edx, edx
            //   8bce                 | mov                 ecx, esi

        $sequence_7 = { c7063e000000 e9???????? c70643000000 e9???????? 803c073a }
            // n = 5, score = 100
            //   c7063e000000         | mov                 dword ptr [esi], 0x3e
            //   e9????????           |                     
            //   c70643000000         | mov                 dword ptr [esi], 0x43
            //   e9????????           |                     
            //   803c073a             | cmp                 byte ptr [edi + eax], 0x3a

        $sequence_8 = { 83f83a 0f87ce010000 ff24859e414000 c60102 e9???????? c60101 }
            // n = 6, score = 100
            //   83f83a               | cmp                 eax, 0x3a
            //   0f87ce010000         | ja                  0x1d4
            //   ff24859e414000       | jmp                 dword ptr [eax*4 + 0x40419e]
            //   c60102               | mov                 byte ptr [ecx], 2
            //   e9????????           |                     
            //   c60101               | mov                 byte ptr [ecx], 1

        $sequence_9 = { 7524 390b 7720 3903 }
            // n = 4, score = 100
            //   7524                 | jne                 0x26
            //   390b                 | cmp                 dword ptr [ebx], ecx
            //   7720                 | ja                  0x22
            //   3903                 | cmp                 dword ptr [ebx], eax

    condition:
        7 of them and filesize < 106496
}