rule win_whiskerspy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.whiskerspy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.whiskerspy"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33ff 8b06 8bcf d3e8 }
            // n = 4, score = 300
            //   33ff                 | xor                 edi, edi
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8bcf                 | mov                 ecx, edi
            //   d3e8                 | shr                 eax, cl

        $sequence_1 = { b867666666 f7e9 488d5c2430 c1fa02 8bc2 }
            // n = 5, score = 200
            //   b867666666           | dec                 eax
            //   f7e9                 | cmp                 eax, ecx
            //   488d5c2430           | je                  0x72
            //   c1fa02               | dec                 eax
            //   8bc2                 | mov                 eax, dword ptr [ebx + 0xe0]

        $sequence_2 = { 884c9c4b 48ffc3 4883fb08 7cd2 0f10442420 }
            // n = 5, score = 200
            //   884c9c4b             | mov                 byte ptr [esp + ebx*4 + 0x4b], cl
            //   48ffc3               | dec                 eax
            //   4883fb08             | inc                 ebx
            //   7cd2                 | dec                 eax
            //   0f10442420           | cmp                 ebx, 8

        $sequence_3 = { 488d0d26120100 483bc1 746d 488b83e0000000 }
            // n = 4, score = 200
            //   488d0d26120100       | mov                 edx, edi
            //   483bc1               | dec                 eax
            //   746d                 | mov                 ecx, eax
            //   488b83e0000000       | dec                 eax

        $sequence_4 = { 4963cd 488d3409 4c8bc6 488bd7 488bc8 }
            // n = 5, score = 200
            //   4963cd               | jl                  0xffffffd8
            //   488d3409             | movups              xmm0, xmmword ptr [esp + 0x20]
            //   4c8bc6               | dec                 ecx
            //   488bd7               | arpl                bp, cx
            //   488bc8               | dec                 eax

        $sequence_5 = { 4c63c2 4d03c0 498d0c3e 488d557c }
            // n = 4, score = 200
            //   4c63c2               | dec                 ecx
            //   4d03c0               | mov                 ecx, esi
            //   498d0c3e             | dec                 eax
            //   488d557c             | lea                 ecx, [0x11226]

        $sequence_6 = { 488bd8 4885c0 7511 498bce ff15???????? }
            // n = 5, score = 200
            //   488bd8               | lea                 esi, [ecx + ecx]
            //   4885c0               | dec                 esp
            //   7511                 | mov                 eax, esi
            //   498bce               | dec                 eax
            //   ff15????????         |                     

        $sequence_7 = { 90 488b4c2468 e8???????? 90 8bc3 }
            // n = 5, score = 200
            //   90                   | mov                 ebx, eax
            //   488b4c2468           | dec                 eax
            //   e8????????           |                     
            //   90                   | test                eax, eax
            //   8bc3                 | jne                 0x16

        $sequence_8 = { 8a85f4f9ffff 8a840df4f9ffff 2c6c 3440 }
            // n = 4, score = 100
            //   8a85f4f9ffff         | shr                 ebp, 0x18
            //   8a840df4f9ffff       | inc                 ecx
            //   2c6c                 | movzx               ebp, al
            //   3440                 | inc                 ecx

        $sequence_9 = { c685c5f9ffff69 c685c6f9ffff5a c685c7f9ffff60 c685c8f9ffff5d }
            // n = 4, score = 100
            //   c685c5f9ffff69       | dec                 ebp
            //   c685c6f9ffff5a       | add                 eax, eax
            //   c685c7f9ffff60       | dec                 ecx
            //   c685c8f9ffff5d       | lea                 ecx, [esi + edi]

        $sequence_10 = { 2c09 3445 88840dccfeffff 41 83f90a 72e8 }
            // n = 6, score = 100
            //   2c09                 | dec                 eax
            //   3445                 | lea                 ebx, [esp + 0x30]
            //   88840dccfeffff       | sar                 edx, 2
            //   41                   | mov                 eax, edx
            //   83f90a               | shr                 edi, 0x10
            //   72e8                 | inc                 ecx

        $sequence_11 = { 1b7c240c 8b4130 2918 8b4120 0110 eb23 }
            // n = 6, score = 100
            //   1b7c240c             | dec                 eax
            //   8b4130               | mov                 ecx, dword ptr [esp + 0x68]
            //   2918                 | nop                 
            //   8b4120               | mov                 eax, ebx
            //   0110                 | dec                 esp
            //   eb23                 | arpl                dx, ax

        $sequence_12 = { eb06 8b4510 8b750c 837f4c00 8945f0 }
            // n = 5, score = 100
            //   eb06                 | test                ah, 0xf
            //   8b4510               | mov                 eax, dword ptr [esi]
            //   8b750c               | mov                 ecx, edi
            //   837f4c00             | shr                 eax, cl
            //   8945f0               | test                al, 1

        $sequence_13 = { 3daaaaaa0a 0f84da000000 8d5801 8b4608 2b06 99 }
            // n = 6, score = 100
            //   3daaaaaa0a           | dec                 eax
            //   0f84da000000         | cmp                 eax, ecx
            //   8d5801               | je                  0x72
            //   8b4608               | dec                 eax
            //   2b06                 | mov                 eax, dword ptr [ebx + 0xe0]
            //   99                   | nop                 

        $sequence_14 = { 8b00 8d8d38fcffff 51 50 e8???????? }
            // n = 5, score = 100
            //   8b00                 | dec                 eax
            //   8d8d38fcffff         | lea                 edx, [ebp + 0x7c]
            //   51                   | mov                 eax, 0x66666667
            //   50                   | imul                ecx
            //   e8????????           |                     

    condition:
        7 of them and filesize < 591872
}