rule win_yakuza_ransomware_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.yakuza_ransomware."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.yakuza_ransomware"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 894da4 3bc8 0f8e1f010000 68e8030000 ffd2 47 897da0 }
            // n = 7, score = 100
            //   894da4               | mov                 dword ptr [ebp - 0x5c], ecx
            //   3bc8                 | cmp                 ecx, eax
            //   0f8e1f010000         | jle                 0x125
            //   68e8030000           | push                0x3e8
            //   ffd2                 | call                edx
            //   47                   | inc                 edi
            //   897da0               | mov                 dword ptr [ebp - 0x60], edi

        $sequence_1 = { 8bce e8???????? 85c0 0f84e6000000 83f802 0f8417010000 f7464000080000 }
            // n = 7, score = 100
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f84e6000000         | je                  0xec
            //   83f802               | cmp                 eax, 2
            //   0f8417010000         | je                  0x11d
            //   f7464000080000       | test                dword ptr [esi + 0x40], 0x800

        $sequence_2 = { 744d 6afd 8d4da8 e8???????? 8b4508 8bcf 83c00c }
            // n = 7, score = 100
            //   744d                 | je                  0x4f
            //   6afd                 | push                -3
            //   8d4da8               | lea                 ecx, [ebp - 0x58]
            //   e8????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8bcf                 | mov                 ecx, edi
            //   83c00c               | add                 eax, 0xc

        $sequence_3 = { eb41 8bc2 bafeffff7f 83c807 3dfeffff7f 0f47c2 8945a0 }
            // n = 7, score = 100
            //   eb41                 | jmp                 0x43
            //   8bc2                 | mov                 eax, edx
            //   bafeffff7f           | mov                 edx, 0x7ffffffe
            //   83c807               | or                  eax, 7
            //   3dfeffff7f           | cmp                 eax, 0x7ffffffe
            //   0f47c2               | cmova               eax, edx
            //   8945a0               | mov                 dword ptr [ebp - 0x60], eax

        $sequence_4 = { 8b01 0f84d6000000 57 ff5044 50 8d4ddc e8???????? }
            // n = 7, score = 100
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   0f84d6000000         | je                  0xdc
            //   57                   | push                edi
            //   ff5044               | call                dword ptr [eax + 0x44]
            //   50                   | push                eax
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   e8????????           |                     

        $sequence_5 = { e8???????? 8907 894704 897df0 8d04f0 894708 c745fc00000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8907                 | mov                 dword ptr [edi], eax
            //   894704               | mov                 dword ptr [edi + 4], eax
            //   897df0               | mov                 dword ptr [ebp - 0x10], edi
            //   8d04f0               | lea                 eax, [eax + esi*8]
            //   894708               | mov                 dword ptr [edi + 8], eax
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0

        $sequence_6 = { 6a02 8bce e8???????? 8bf0 6a00 8b8dd4f1ffff e8???????? }
            // n = 7, score = 100
            //   6a02                 | push                2
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   6a00                 | push                0
            //   8b8dd4f1ffff         | mov                 ecx, dword ptr [ebp - 0xe2c]
            //   e8????????           |                     

        $sequence_7 = { e9???????? 83e92c e9???????? 2b49fc 81e910010000 e9???????? 2b49fc }
            // n = 7, score = 100
            //   e9????????           |                     
            //   83e92c               | sub                 ecx, 0x2c
            //   e9????????           |                     
            //   2b49fc               | sub                 ecx, dword ptr [ecx - 4]
            //   81e910010000         | sub                 ecx, 0x110
            //   e9????????           |                     
            //   2b49fc               | sub                 ecx, dword ptr [ecx - 4]

        $sequence_8 = { c3 8b4de8 e9???????? 8b4de8 e9???????? 8d4de8 e9???????? }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   e9????????           |                     
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   e9????????           |                     
            //   8d4de8               | lea                 ecx, [ebp - 0x18]
            //   e9????????           |                     

        $sequence_9 = { f00fc14120 7523 8bb55cffffff 0f1f4000 85f6 7415 8bce }
            // n = 7, score = 100
            //   f00fc14120           | lock xadd           dword ptr [ecx + 0x20], eax
            //   7523                 | jne                 0x25
            //   8bb55cffffff         | mov                 esi, dword ptr [ebp - 0xa4]
            //   0f1f4000             | nop                 dword ptr [eax]
            //   85f6                 | test                esi, esi
            //   7415                 | je                  0x17
            //   8bce                 | mov                 ecx, esi

    condition:
        7 of them and filesize < 2811904
}