rule elf_hideandseek_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects elf.hideandseek."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/elf.hideandseek"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d1406 89cb 29c3 89d8 eb07 803a20 740f }
            // n = 7, score = 100
            //   8d1406               | lea                 edx, [esi + eax]
            //   89cb                 | mov                 ebx, ecx
            //   29c3                 | sub                 ebx, eax
            //   89d8                 | mov                 eax, ebx
            //   eb07                 | jmp                 9
            //   803a20               | cmp                 byte ptr [edx], 0x20
            //   740f                 | je                  0x11

        $sequence_1 = { 50 8d44241c 50 ff74242c e8???????? 59 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   8d44241c             | lea                 eax, [esp + 0x1c]
            //   50                   | push                eax
            //   ff74242c             | push                dword ptr [esp + 0x2c]
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_2 = { 8b4530 0facd010 c1ea10 88412d }
            // n = 4, score = 100
            //   8b4530               | mov                 eax, dword ptr [ebp + 0x30]
            //   0facd010             | shrd                eax, edx, 0x10
            //   c1ea10               | shr                 edx, 0x10
            //   88412d               | mov                 byte ptr [ecx + 0x2d], al

        $sequence_3 = { 53 83ec0c 8b7c2420 8b6c2424 e8???????? 31d2 84c0 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   83ec0c               | sub                 esp, 0xc
            //   8b7c2420             | mov                 edi, dword ptr [esp + 0x20]
            //   8b6c2424             | mov                 ebp, dword ptr [esp + 0x24]
            //   e8????????           |                     
            //   31d2                 | xor                 edx, edx
            //   84c0                 | test                al, al

        $sequence_4 = { 4f 85ff 75e4 eb42 a1???????? 85c0 }
            // n = 6, score = 100
            //   4f                   | dec                 edi
            //   85ff                 | test                edi, edi
            //   75e4                 | jne                 0xffffffe6
            //   eb42                 | jmp                 0x44
            //   a1????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_5 = { 752e 85ed 7512 52 52 50 56 }
            // n = 7, score = 100
            //   752e                 | jne                 0x30
            //   85ed                 | test                ebp, ebp
            //   7512                 | jne                 0x14
            //   52                   | push                edx
            //   52                   | push                edx
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_6 = { 53 53 e8???????? 83c410 89c3 85c0 0f8577050000 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   89c3                 | mov                 ebx, eax
            //   85c0                 | test                eax, eax
            //   0f8577050000         | jne                 0x57d

        $sequence_7 = { 8a03 84c0 780e 0fb6c0 894500 8d4301 e9???????? }
            // n = 7, score = 100
            //   8a03                 | mov                 al, byte ptr [ebx]
            //   84c0                 | test                al, al
            //   780e                 | js                  0x10
            //   0fb6c0               | movzx               eax, al
            //   894500               | mov                 dword ptr [ebp], eax
            //   8d4301               | lea                 eax, [ebx + 1]
            //   e9????????           |                     

        $sequence_8 = { e8???????? 5b 85c0 5e 0f858dfeffff eb12 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   5b                   | pop                 ebx
            //   85c0                 | test                eax, eax
            //   5e                   | pop                 esi
            //   0f858dfeffff         | jne                 0xfffffe93
            //   eb12                 | jmp                 0x14

        $sequence_9 = { 83c410 e9???????? c7460c00000000 e9???????? 50 50 }
            // n = 6, score = 100
            //   83c410               | add                 esp, 0x10
            //   e9????????           |                     
            //   c7460c00000000       | mov                 dword ptr [esi + 0xc], 0
            //   e9????????           |                     
            //   50                   | push                eax
            //   50                   | push                eax

    condition:
        7 of them and filesize < 196608
}