rule osx_coldroot_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/osx.coldroot_rat"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8945f4 e9???????? c745f403000000 e9???????? 8b45fc e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   e9????????           |                     
            //   c745f403000000       | mov                 dword ptr [ebp - 0xc], 3
            //   e9????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   e8????????           |                     

        $sequence_1 = { eb0a 8b55f4 8b45f0 0fb34228 8b45f4 e8???????? 84c0 }
            // n = 7, score = 100
            //   eb0a                 | jmp                 0xc
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   0fb34228             | btr                 dword ptr [edx + 0x28], eax
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   e8????????           |                     
            //   84c0                 | test                al, al

        $sequence_2 = { e8???????? 89c7 89d6 668b5dfc 6685db 744a c7042400000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   89c7                 | mov                 edi, eax
            //   89d6                 | mov                 esi, edx
            //   668b5dfc             | mov                 bx, word ptr [ebp - 4]
            //   6685db               | test                bx, bx
            //   744a                 | je                  0x4c
            //   c7042400000000       | mov                 dword ptr [esp], 0

        $sequence_3 = { e8???????? 8945e0 8955e4 d945e0 df7de0 9b 8b55fc }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8955e4               | mov                 dword ptr [ebp - 0x1c], edx
            //   d945e0               | fld                 dword ptr [ebp - 0x20]
            //   df7de0               | fistp               qword ptr [ebp - 0x20]
            //   9b                   | wait                
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]

        $sequence_4 = { e8???????? 8d45fc e8???????? 8b450c e8???????? 8b45cc 85c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   e8????????           |                     
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   e8????????           |                     
            //   8b45cc               | mov                 eax, dword ptr [ebp - 0x34]
            //   85c0                 | test                eax, eax

        $sequence_5 = { 8b0c24 8d913bffffff 89500c 8b0c24 8d915bffffff 895010 8b0c24 }
            // n = 7, score = 100
            //   8b0c24               | mov                 ecx, dword ptr [esp]
            //   8d913bffffff         | lea                 edx, [ecx - 0xc5]
            //   89500c               | mov                 dword ptr [eax + 0xc], edx
            //   8b0c24               | mov                 ecx, dword ptr [esp]
            //   8d915bffffff         | lea                 edx, [ecx - 0xa5]
            //   895010               | mov                 dword ptr [eax + 0x10], edx
            //   8b0c24               | mov                 ecx, dword ptr [esp]

        $sequence_6 = { eb05 b902000000 8b442404 8b400c 8a5002 88542448 8b54244c }
            // n = 7, score = 100
            //   eb05                 | jmp                 7
            //   b902000000           | mov                 ecx, 2
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   8a5002               | mov                 dl, byte ptr [eax + 2]
            //   88542448             | mov                 byte ptr [esp + 0x48], dl
            //   8b54244c             | mov                 edx, dword ptr [esp + 0x4c]

        $sequence_7 = { 8d45f8 890424 8b83f9261600 89442404 e8???????? 8b5df4 89ec }
            // n = 7, score = 100
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   890424               | mov                 dword ptr [esp], eax
            //   8b83f9261600         | mov                 eax, dword ptr [ebx + 0x1626f9]
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   e8????????           |                     
            //   8b5df4               | mov                 ebx, dword ptr [ebp - 0xc]
            //   89ec                 | mov                 esp, ebp

        $sequence_8 = { ff5340 8b4708 8b55fc b101 e8???????? 89c6 85f6 }
            // n = 7, score = 100
            //   ff5340               | call                dword ptr [ebx + 0x40]
            //   8b4708               | mov                 eax, dword ptr [edi + 8]
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   b101                 | mov                 cl, 1
            //   e8????????           |                     
            //   89c6                 | mov                 esi, eax
            //   85f6                 | test                esi, esi

        $sequence_9 = { e8???????? 89c3 ba00000000 89d8 8b0b ff91a8000000 8b45fc }
            // n = 7, score = 100
            //   e8????????           |                     
            //   89c3                 | mov                 ebx, eax
            //   ba00000000           | mov                 edx, 0
            //   89d8                 | mov                 eax, ebx
            //   8b0b                 | mov                 ecx, dword ptr [ebx]
            //   ff91a8000000         | call                dword ptr [ecx + 0xa8]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

    condition:
        7 of them and filesize < 6585656
}