rule osx_komplex_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/osx.komplex"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 01c1 4c 89ce 8b55cc e8???????? 48 }
            // n = 6, score = 400
            //   01c1                 | add                 ecx, eax
            //   4c                   | dec                 esp
            //   89ce                 | mov                 esi, ecx
            //   8b55cc               | mov                 edx, dword ptr [ebp - 0x34]
            //   e8????????           |                     
            //   48                   | dec                 eax

        $sequence_1 = { 894db0 e8???????? e9???????? 48 }
            // n = 4, score = 400
            //   894db0               | mov                 dword ptr [ebp - 0x50], ecx
            //   e8????????           |                     
            //   e9????????           |                     
            //   48                   | dec                 eax

        $sequence_2 = { 48 8b55d8 8975d4 48 89ce }
            // n = 5, score = 400
            //   48                   | dec                 eax
            //   8b55d8               | mov                 edx, dword ptr [ebp - 0x28]
            //   8975d4               | mov                 dword ptr [ebp - 0x2c], esi
            //   48                   | dec                 eax
            //   89ce                 | mov                 esi, ecx

        $sequence_3 = { 0f854e000000 b8???????? 89c7 e8???????? }
            // n = 4, score = 400
            //   0f854e000000         | jne                 0x54
            //   b8????????           |                     
            //   89c7                 | mov                 edi, eax
            //   e8????????           |                     

        $sequence_4 = { 3d00000000 48 894580 0f8409000000 }
            // n = 4, score = 400
            //   3d00000000           | cmp                 eax, 0
            //   48                   | dec                 eax
            //   894580               | mov                 dword ptr [ebp - 0x80], eax
            //   0f8409000000         | je                  0xf

        $sequence_5 = { 48 897db0 48 89c7 48 894da8 e8???????? }
            // n = 7, score = 400
            //   48                   | dec                 eax
            //   897db0               | mov                 dword ptr [ebp - 0x50], edi
            //   48                   | dec                 eax
            //   89c7                 | mov                 edi, eax
            //   48                   | dec                 eax
            //   894da8               | mov                 dword ptr [ebp - 0x58], ecx
            //   e8????????           |                     

        $sequence_6 = { 0f850c000000 48 8b45e0 48 8b4df0 c6040100 e9???????? }
            // n = 7, score = 400
            //   0f850c000000         | jne                 0x12
            //   48                   | dec                 eax
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   48                   | dec                 eax
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   c6040100             | mov                 byte ptr [ecx + eax], 0
            //   e9????????           |                     

        $sequence_7 = { 81fa00000000 888507ffffff 48 8995f8feffff 0f840c000000 48 8bbdf8feffff }
            // n = 7, score = 400
            //   81fa00000000         | cmp                 edx, 0
            //   888507ffffff         | mov                 byte ptr [ebp - 0xf9], al
            //   48                   | dec                 eax
            //   8995f8feffff         | mov                 dword ptr [ebp - 0x108], edx
            //   0f840c000000         | je                  0x12
            //   48                   | dec                 eax
            //   8bbdf8feffff         | mov                 edi, dword ptr [ebp - 0x108]

        $sequence_8 = { 8955e8 48 8b7df8 e8???????? 48 }
            // n = 5, score = 400
            //   8955e8               | mov                 dword ptr [ebp - 0x18], edx
            //   48                   | dec                 eax
            //   8b7df8               | mov                 edi, dword ptr [ebp - 8]
            //   e8????????           |                     
            //   48                   | dec                 eax

        $sequence_9 = { 48 8b75e8 e8???????? 3d00000000 0f8575000000 48 8b45e0 }
            // n = 7, score = 400
            //   48                   | dec                 eax
            //   8b75e8               | mov                 esi, dword ptr [ebp - 0x18]
            //   e8????????           |                     
            //   3d00000000           | cmp                 eax, 0
            //   0f8575000000         | jne                 0x7b
            //   48                   | dec                 eax
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]

    condition:
        7 of them and filesize < 3533816
}