rule osx_retefe_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/osx.retefe"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b35???????? b901000000 4c 89fa 5b 41 }
            // n = 6, score = 800
            //   8b35????????         |                     
            //   b901000000           | mov                 ecx, 1
            //   4c                   | dec                 esp
            //   89fa                 | mov                 edx, edi
            //   5b                   | pop                 ebx
            //   41                   | inc                 ecx

        $sequence_1 = { ffc3 48 ffc0 49 ffce }
            // n = 5, score = 800
            //   ffc3                 | inc                 ebx
            //   48                   | dec                 eax
            //   ffc0                 | inc                 eax
            //   49                   | dec                 ecx
            //   ffce                 | dec                 esi

        $sequence_2 = { 89f6 48 89fb 48 8b3d???????? 48 8b35???????? }
            // n = 7, score = 800
            //   89f6                 | mov                 esi, esi
            //   48                   | dec                 eax
            //   89fb                 | mov                 ebx, edi
            //   48                   | dec                 eax
            //   8b3d????????         |                     
            //   48                   | dec                 eax
            //   8b35????????         |                     

        $sequence_3 = { b901000000 4c 89fa 5b }
            // n = 4, score = 800
            //   b901000000           | mov                 ecx, 1
            //   4c                   | dec                 esp
            //   89fa                 | mov                 edx, edi
            //   5b                   | pop                 ebx

        $sequence_4 = { 8b35???????? b901000000 4c 89fa 5b }
            // n = 5, score = 800
            //   8b35????????         |                     
            //   b901000000           | mov                 ecx, 1
            //   4c                   | dec                 esp
            //   89fa                 | mov                 edx, edi
            //   5b                   | pop                 ebx

        $sequence_5 = { 48 8b3d???????? 48 8b35???????? b901000000 4c 89fa }
            // n = 7, score = 800
            //   48                   | dec                 eax
            //   8b3d????????         |                     
            //   48                   | dec                 eax
            //   8b35????????         |                     
            //   b901000000           | mov                 ecx, 1
            //   4c                   | dec                 esp
            //   89fa                 | mov                 edx, edi

        $sequence_6 = { 41 ffd7 49 89c7 4c 89e7 }
            // n = 6, score = 800
            //   41                   | inc                 ecx
            //   ffd7                 | call                edi
            //   49                   | dec                 ecx
            //   89c7                 | mov                 edi, eax
            //   4c                   | dec                 esp
            //   89e7                 | mov                 edi, esp

        $sequence_7 = { 89fa 5b 41 5c 41 5e 41 }
            // n = 7, score = 800
            //   89fa                 | mov                 edx, edi
            //   5b                   | pop                 ebx
            //   41                   | inc                 ecx
            //   5c                   | pop                 esp
            //   41                   | inc                 ecx
            //   5e                   | pop                 esi
            //   41                   | inc                 ecx

        $sequence_8 = { 89e7 41 ffd7 49 89c7 4c 89e7 }
            // n = 7, score = 800
            //   89e7                 | mov                 edi, esp
            //   41                   | inc                 ecx
            //   ffd7                 | call                edi
            //   49                   | dec                 ecx
            //   89c7                 | mov                 edi, eax
            //   4c                   | dec                 esp
            //   89e7                 | mov                 edi, esp

        $sequence_9 = { 41 ffd7 49 89c7 4c 89e7 ff15???????? }
            // n = 7, score = 800
            //   41                   | inc                 ecx
            //   ffd7                 | call                edi
            //   49                   | dec                 ecx
            //   89c7                 | mov                 edi, eax
            //   4c                   | dec                 esp
            //   89e7                 | mov                 edi, esp
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 193312
}