rule win_7ev3n_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.7ev3n."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.7ev3n"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 75f5 2bf9 d1ff 6a00 8d8558fdffff }
            // n = 5, score = 100
            //   75f5                 | jne                 0xfffffff7
            //   2bf9                 | sub                 edi, ecx
            //   d1ff                 | sar                 edi, 1
            //   6a00                 | push                0
            //   8d8558fdffff         | lea                 eax, [ebp - 0x2a8]

        $sequence_1 = { b8ffff0000 0fb7c0 0fb7c0 0fb7f0 eb52 }
            // n = 5, score = 100
            //   b8ffff0000           | mov                 eax, 0xffff
            //   0fb7c0               | movzx               eax, ax
            //   0fb7c0               | movzx               eax, ax
            //   0fb7f0               | movzx               esi, ax
            //   eb52                 | jmp                 0x54

        $sequence_2 = { 660fd68518e1ffff 0fb705???????? 66898520e1ffff f30f7e05???????? 660fd6850ce1ffff 0fb705???????? }
            // n = 6, score = 100
            //   660fd68518e1ffff     | movq                qword ptr [ebp - 0x1ee8], xmm0
            //   0fb705????????       |                     
            //   66898520e1ffff       | mov                 word ptr [ebp - 0x1ee0], ax
            //   f30f7e05????????     |                     
            //   660fd6850ce1ffff     | movq                qword ptr [ebp - 0x1ef4], xmm0
            //   0fb705????????       |                     

        $sequence_3 = { 8bd0 8bf0 668b02 83c202 6685c0 75f5 8dbd38f9ffff }
            // n = 7, score = 100
            //   8bd0                 | mov                 edx, eax
            //   8bf0                 | mov                 esi, eax
            //   668b02               | mov                 ax, word ptr [edx]
            //   83c202               | add                 edx, 2
            //   6685c0               | test                ax, ax
            //   75f5                 | jne                 0xfffffff7
            //   8dbd38f9ffff         | lea                 edi, [ebp - 0x6c8]

        $sequence_4 = { 660fd6850cf9ffff 0fb705???????? 66898514f9ffff f30f7e05???????? 660fd68500f9ffff 0fb705???????? 66898508f9ffff }
            // n = 7, score = 100
            //   660fd6850cf9ffff     | movq                qword ptr [ebp - 0x6f4], xmm0
            //   0fb705????????       |                     
            //   66898514f9ffff       | mov                 word ptr [ebp - 0x6ec], ax
            //   f30f7e05????????     |                     
            //   660fd68500f9ffff     | movq                qword ptr [ebp - 0x700], xmm0
            //   0fb705????????       |                     
            //   66898508f9ffff       | mov                 word ptr [ebp - 0x6f8], ax

        $sequence_5 = { 6a00 8d858ce8ffff 50 8d8dd0cdffff e8???????? 8bce 2bcf }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   8d858ce8ffff         | lea                 eax, [ebp - 0x1774]
            //   50                   | push                eax
            //   8d8dd0cdffff         | lea                 ecx, [ebp - 0x3230]
            //   e8????????           |                     
            //   8bce                 | mov                 ecx, esi
            //   2bcf                 | sub                 ecx, edi

        $sequence_6 = { d1ff 6a00 8d85e8f2ffff 50 8d8dd0cdffff e8???????? 8bce }
            // n = 7, score = 100
            //   d1ff                 | sar                 edi, 1
            //   6a00                 | push                0
            //   8d85e8f2ffff         | lea                 eax, [ebp - 0xd18]
            //   50                   | push                eax
            //   8d8dd0cdffff         | lea                 ecx, [ebp - 0x3230]
            //   e8????????           |                     
            //   8bce                 | mov                 ecx, esi

        $sequence_7 = { 0f4305???????? a3???????? c3 b9???????? e8???????? 68???????? e8???????? }
            // n = 7, score = 100
            //   0f4305????????       |                     
            //   a3????????           |                     
            //   c3                   | ret                 
            //   b9????????           |                     
            //   e8????????           |                     
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_8 = { 85ff 7f17 7c05 83fe01 7710 0f57c0 660f1345e0 }
            // n = 7, score = 100
            //   85ff                 | test                edi, edi
            //   7f17                 | jg                  0x19
            //   7c05                 | jl                  7
            //   83fe01               | cmp                 esi, 1
            //   7710                 | ja                  0x12
            //   0f57c0               | xorps               xmm0, xmm0
            //   660f1345e0           | movlpd              qword ptr [ebp - 0x20], xmm0

        $sequence_9 = { 83c702 6685c0 75f5 2bf9 d1ff 6a00 8d85d8e1ffff }
            // n = 7, score = 100
            //   83c702               | add                 edi, 2
            //   6685c0               | test                ax, ax
            //   75f5                 | jne                 0xfffffff7
            //   2bf9                 | sub                 edi, ecx
            //   d1ff                 | sar                 edi, 1
            //   6a00                 | push                0
            //   8d85d8e1ffff         | lea                 eax, [ebp - 0x1e28]

    condition:
        7 of them and filesize < 803840
}