rule win_adkoob_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.adkoob."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.adkoob"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c78514ffffffd2000000 8d8d20ffffff 898d08ffffff 898d0cffffff 33c9 898d04ffffff 898d10ffffff }
            // n = 7, score = 400
            //   c78514ffffffd2000000     | mov    dword ptr [ebp - 0xec], 0xd2
            //   8d8d20ffffff         | lea                 ecx, [ebp - 0xe0]
            //   898d08ffffff         | mov                 dword ptr [ebp - 0xf8], ecx
            //   898d0cffffff         | mov                 dword ptr [ebp - 0xf4], ecx
            //   33c9                 | xor                 ecx, ecx
            //   898d04ffffff         | mov                 dword ptr [ebp - 0xfc], ecx
            //   898d10ffffff         | mov                 dword ptr [ebp - 0xf0], ecx

        $sequence_1 = { 8b4ddc 41 894ddc 85c0 7485 57 e8???????? }
            // n = 7, score = 400
            //   8b4ddc               | mov                 ecx, dword ptr [ebp - 0x24]
            //   41                   | inc                 ecx
            //   894ddc               | mov                 dword ptr [ebp - 0x24], ecx
            //   85c0                 | test                eax, eax
            //   7485                 | je                  0xffffff87
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_2 = { 8b75f4 56 ff7510 8d45ec 51 50 8bcb }
            // n = 7, score = 400
            //   8b75f4               | mov                 esi, dword ptr [ebp - 0xc]
            //   56                   | push                esi
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   8bcb                 | mov                 ecx, ebx

        $sequence_3 = { 8b85e4feffff c1e104 898dd0feffff 8b4010 8b7c0104 8bcf e8???????? }
            // n = 7, score = 400
            //   8b85e4feffff         | mov                 eax, dword ptr [ebp - 0x11c]
            //   c1e104               | shl                 ecx, 4
            //   898dd0feffff         | mov                 dword ptr [ebp - 0x130], ecx
            //   8b4010               | mov                 eax, dword ptr [eax + 0x10]
            //   8b7c0104             | mov                 edi, dword ptr [ecx + eax + 4]
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     

        $sequence_4 = { 8bf0 e8???????? 8b4d98 3b4da0 7407 6a0e e8???????? }
            // n = 7, score = 400
            //   8bf0                 | mov                 esi, eax
            //   e8????????           |                     
            //   8b4d98               | mov                 ecx, dword ptr [ebp - 0x68]
            //   3b4da0               | cmp                 ecx, dword ptr [ebp - 0x60]
            //   7407                 | je                  9
            //   6a0e                 | push                0xe
            //   e8????????           |                     

        $sequence_5 = { 8bc6 8bcf 2b85ccbfffff 50 8d85f4bfffff 50 e8???????? }
            // n = 7, score = 400
            //   8bc6                 | mov                 eax, esi
            //   8bcf                 | mov                 ecx, edi
            //   2b85ccbfffff         | sub                 eax, dword ptr [ebp - 0x4034]
            //   50                   | push                eax
            //   8d85f4bfffff         | lea                 eax, [ebp - 0x400c]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_6 = { e8???????? 6a00 53 8d4c242c e8???????? 8b7c2454 b828010000 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   6a00                 | push                0
            //   53                   | push                ebx
            //   8d4c242c             | lea                 ecx, [esp + 0x2c]
            //   e8????????           |                     
            //   8b7c2454             | mov                 edi, dword ptr [esp + 0x54]
            //   b828010000           | mov                 eax, 0x128

        $sequence_7 = { 8bd9 56 57 895df0 8b03 8b7304 8945d4 }
            // n = 7, score = 400
            //   8bd9                 | mov                 ebx, ecx
            //   56                   | push                esi
            //   57                   | push                edi
            //   895df0               | mov                 dword ptr [ebp - 0x10], ebx
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   8b7304               | mov                 esi, dword ptr [ebx + 4]
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax

        $sequence_8 = { ff75e8 53 6a01 ff75e0 ffd6 85c0 7431 }
            // n = 7, score = 400
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   53                   | push                ebx
            //   6a01                 | push                1
            //   ff75e0               | push                dword ptr [ebp - 0x20]
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   7431                 | je                  0x33

        $sequence_9 = { e8???????? 8bf0 83c40c 85f6 0f85ea000000 8b45dc ff45d8 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   83c40c               | add                 esp, 0xc
            //   85f6                 | test                esi, esi
            //   0f85ea000000         | jne                 0xf0
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]
            //   ff45d8               | inc                 dword ptr [ebp - 0x28]

    condition:
        7 of them and filesize < 1867776
}