rule win_afrodita_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.afrodita."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.afrodita"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d8d6cffffff 895dec e8???????? 8b5de8 8bc7 83c80c c745fc03000000 }
            // n = 7, score = 300
            //   8d8d6cffffff         | lea                 ecx, [ebp - 0x94]
            //   895dec               | mov                 dword ptr [ebp - 0x14], ebx
            //   e8????????           |                     
            //   8b5de8               | mov                 ebx, dword ptr [ebp - 0x18]
            //   8bc7                 | mov                 eax, edi
            //   83c80c               | or                  eax, 0xc
            //   c745fc03000000       | mov                 dword ptr [ebp - 4], 3

        $sequence_1 = { e8???????? 85c0 8d4dd0 0f94c3 e8???????? 8ac3 }
            // n = 6, score = 300
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   8d4dd0               | lea                 ecx, [ebp - 0x30]
            //   0f94c3               | sete                bl
            //   e8????????           |                     
            //   8ac3                 | mov                 al, bl

        $sequence_2 = { 8bc6 83e0c0 8945f0 8d4110 8945e4 8bc2 2bc1 }
            // n = 7, score = 300
            //   8bc6                 | mov                 eax, esi
            //   83e0c0               | and                 eax, 0xffffffc0
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8d4110               | lea                 eax, [ecx + 0x10]
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8bc2                 | mov                 eax, edx
            //   2bc1                 | sub                 eax, ecx

        $sequence_3 = { c3 6a00 8bce e8???????? 8b7d0c }
            // n = 5, score = 300
            //   c3                   | ret                 
            //   6a00                 | push                0
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]

        $sequence_4 = { c745fc05000000 0d3c001800 8945ec 8d4584 50 }
            // n = 5, score = 300
            //   c745fc05000000       | mov                 dword ptr [ebp - 4], 5
            //   0d3c001800           | or                  eax, 0x18003c
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   8d4584               | lea                 eax, [ebp - 0x7c]
            //   50                   | push                eax

        $sequence_5 = { c745fc04000000 395d10 0f8600010000 6690 6a02 8d8d70ffffff e8???????? }
            // n = 7, score = 300
            //   c745fc04000000       | mov                 dword ptr [ebp - 4], 4
            //   395d10               | cmp                 dword ptr [ebp + 0x10], ebx
            //   0f8600010000         | jbe                 0x106
            //   6690                 | nop                 
            //   6a02                 | push                2
            //   8d8d70ffffff         | lea                 ecx, [ebp - 0x90]
            //   e8????????           |                     

        $sequence_6 = { 8bc3 eb08 8d040a 3bc3 0f42c3 3dffffff3f 0f87c8000000 }
            // n = 7, score = 300
            //   8bc3                 | mov                 eax, ebx
            //   eb08                 | jmp                 0xa
            //   8d040a               | lea                 eax, [edx + ecx]
            //   3bc3                 | cmp                 eax, ebx
            //   0f42c3               | cmovb               eax, ebx
            //   3dffffff3f           | cmp                 eax, 0x3fffffff
            //   0f87c8000000         | ja                  0xce

        $sequence_7 = { ff5018 8b7d08 0f1f00 83f8ff 7504 b301 eb56 }
            // n = 7, score = 300
            //   ff5018               | call                dword ptr [eax + 0x18]
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   0f1f00               | nop                 dword ptr [eax]
            //   83f8ff               | cmp                 eax, -1
            //   7504                 | jne                 6
            //   b301                 | mov                 bl, 1
            //   eb56                 | jmp                 0x58

        $sequence_8 = { ff7514 890b 8d4e10 ff7510 897b04 8b01 53 }
            // n = 7, score = 300
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   890b                 | mov                 dword ptr [ebx], ecx
            //   8d4e10               | lea                 ecx, [esi + 0x10]
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   897b04               | mov                 dword ptr [ebx + 4], edi
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   53                   | push                ebx

        $sequence_9 = { c645fc0d 33c0 56 8b11 8bca f3ab 85d2 }
            // n = 7, score = 300
            //   c645fc0d             | mov                 byte ptr [ebp - 4], 0xd
            //   33c0                 | xor                 eax, eax
            //   56                   | push                esi
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8bca                 | mov                 ecx, edx
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   85d2                 | test                edx, edx

    condition:
        7 of them and filesize < 2334720
}