rule win_alice_atm_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.alice_atm."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.alice_atm"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4b 75d4 ff75f8 e8???????? }
            // n = 4, score = 200
            //   4b                   | dec                 ebx
            //   75d4                 | jne                 0xffffffd6
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   e8????????           |                     

        $sequence_1 = { 56 57 33ff 57 e8???????? a3???????? 6a03 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   57                   | push                edi
            //   33ff                 | xor                 edi, edi
            //   57                   | push                edi
            //   e8????????           |                     
            //   a3????????           |                     
            //   6a03                 | push                3

        $sequence_2 = { 6a40 e8???????? 0bc0 7434 8945fc 8bf8 }
            // n = 6, score = 200
            //   6a40                 | push                0x40
            //   e8????????           |                     
            //   0bc0                 | or                  eax, eax
            //   7434                 | je                  0x36
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8bf8                 | mov                 edi, eax

        $sequence_3 = { 83c604 33ff 47 3b7d0c 741b ff36 57 }
            // n = 7, score = 200
            //   83c604               | add                 esi, 4
            //   33ff                 | xor                 edi, edi
            //   47                   | inc                 edi
            //   3b7d0c               | cmp                 edi, dword ptr [ebp + 0xc]
            //   741b                 | je                  0x1d
            //   ff36                 | push                dword ptr [esi]
            //   57                   | push                edi

        $sequence_4 = { ff7508 51 ff35???????? 68???????? ff15???????? 0bc0 743f }
            // n = 7, score = 200
            //   ff7508               | push                dword ptr [ebp + 8]
            //   51                   | push                ecx
            //   ff35????????         |                     
            //   68????????           |                     
            //   ff15????????         |                     
            //   0bc0                 | or                  eax, eax
            //   743f                 | je                  0x41

        $sequence_5 = { 0fb7c0 8945f8 8b7d10 83ff00 }
            // n = 4, score = 200
            //   0fb7c0               | movzx               eax, ax
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8b7d10               | mov                 edi, dword ptr [ebp + 0x10]
            //   83ff00               | cmp                 edi, 0

        $sequence_6 = { ff15???????? 0bc0 742a 8bd8 833d????????00 740b }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   0bc0                 | or                  eax, eax
            //   742a                 | je                  0x2c
            //   8bd8                 | mov                 ebx, eax
            //   833d????????00       |                     
            //   740b                 | je                  0xd

        $sequence_7 = { 897dfc 8d45f8 50 6a00 ff7508 e8???????? }
            // n = 6, score = 200
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     

        $sequence_8 = { e9???????? 817d0c11010000 0f85ed000000 8b4d10 }
            // n = 4, score = 200
            //   e9????????           |                     
            //   817d0c11010000       | cmp                 dword ptr [ebp + 0xc], 0x111
            //   0f85ed000000         | jne                 0xf3
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]

        $sequence_9 = { 817e0c20202000 0f8480000000 ff36 68???????? 8d45f8 }
            // n = 5, score = 200
            //   817e0c20202000       | cmp                 dword ptr [esi + 0xc], 0x202020
            //   0f8480000000         | je                  0x86
            //   ff36                 | push                dword ptr [esi]
            //   68????????           |                     
            //   8d45f8               | lea                 eax, [ebp - 8]

    condition:
        7 of them and filesize < 49152
}