rule win_allaple_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.allaple."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.allaple"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 03c2 c1f803 8b4d08 33d2 8a1401 8b45f4 25ff000000 }
            // n = 7, score = 300
            //   03c2                 | add                 eax, edx
            //   c1f803               | sar                 eax, 3
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   33d2                 | xor                 edx, edx
            //   8a1401               | mov                 dl, byte ptr [ecx + eax]
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   25ff000000           | and                 eax, 0xff

        $sequence_1 = { e8???????? 83c40c 8d45f8 50 8d85a0fdffff 50 ff75fc }
            // n = 7, score = 300
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   8d85a0fdffff         | lea                 eax, [ebp - 0x260]
            //   50                   | push                eax
            //   ff75fc               | push                dword ptr [ebp - 4]

        $sequence_2 = { 03d1 8955f8 8b45fc 83c001 8945fc 8b4df0 034dec }
            // n = 7, score = 300
            //   03d1                 | add                 edx, ecx
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   83c001               | add                 eax, 1
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   034dec               | add                 ecx, dword ptr [ebp - 0x14]

        $sequence_3 = { ff75fc 8d4df0 51 e8???????? 83c408 8d8578ffffff 50 }
            // n = 7, score = 300
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   8d4df0               | lea                 ecx, [ebp - 0x10]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8d8578ffffff         | lea                 eax, [ebp - 0x88]
            //   50                   | push                eax

        $sequence_4 = { 8b55f4 33d1 0355b0 8b45fc 8d8c10442229f4 894dfc 8b55fc }
            // n = 7, score = 300
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   33d1                 | xor                 edx, ecx
            //   0355b0               | add                 edx, dword ptr [ebp - 0x50]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8d8c10442229f4       | lea                 ecx, [eax + edx - 0xbd6ddbc]
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]

        $sequence_5 = { 55 8bec 8b5510 8b4d0c 8b4108 }
            // n = 5, score = 300
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8b4108               | mov                 eax, dword ptr [ecx + 8]

        $sequence_6 = { 56 57 8b5d08 8b5b04 c7432c00000000 5f }
            // n = 6, score = 300
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   8b5b04               | mov                 ebx, dword ptr [ebx + 4]
            //   c7432c00000000       | mov                 dword ptr [ebx + 0x2c], 0
            //   5f                   | pop                 edi

        $sequence_7 = { 894821 8b450c 5f 5e 8be5 5d c20c00 }
            // n = 7, score = 300
            //   894821               | mov                 dword ptr [eax + 0x21], ecx
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20c00               | ret                 0xc

        $sequence_8 = { 33ff 683f000f00 57 57 ff15???????? 8bd8 3bc7 }
            // n = 7, score = 300
            //   33ff                 | xor                 edi, edi
            //   683f000f00           | push                0xf003f
            //   57                   | push                edi
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   3bc7                 | cmp                 eax, edi

        $sequence_9 = { 8b4208 33852cffffff 3345cc 8945e4 8b4d08 8b510c }
            // n = 6, score = 300
            //   8b4208               | mov                 eax, dword ptr [edx + 8]
            //   33852cffffff         | xor                 eax, dword ptr [ebp - 0xd4]
            //   3345cc               | xor                 eax, dword ptr [ebp - 0x34]
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b510c               | mov                 edx, dword ptr [ecx + 0xc]

    condition:
        7 of them and filesize < 253952
}