rule win_alma_locker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.alma_locker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.alma_locker"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c404 83bdc8feffff08 720e ffb5b4feffff e8???????? }
            // n = 5, score = 100
            //   83c404               | add                 esp, 4
            //   83bdc8feffff08       | cmp                 dword ptr [ebp - 0x138], 8
            //   720e                 | jb                  0x10
            //   ffb5b4feffff         | push                dword ptr [ebp - 0x14c]
            //   e8????????           |                     

        $sequence_1 = { e8???????? 83c404 83bdc8feffff08 720e ffb5b4feffff e8???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   83bdc8feffff08       | cmp                 dword ptr [ebp - 0x138], 8
            //   720e                 | jb                  0x10
            //   ffb5b4feffff         | push                dword ptr [ebp - 0x14c]
            //   e8????????           |                     

        $sequence_2 = { 8d8d70fbffff e8???????? 8d85c8faffff c645fc21 50 8bd3 8d8da0fbffff }
            // n = 7, score = 100
            //   8d8d70fbffff         | lea                 ecx, [ebp - 0x490]
            //   e8????????           |                     
            //   8d85c8faffff         | lea                 eax, [ebp - 0x538]
            //   c645fc21             | mov                 byte ptr [ebp - 4], 0x21
            //   50                   | push                eax
            //   8bd3                 | mov                 edx, ebx
            //   8d8da0fbffff         | lea                 ecx, [ebp - 0x460]

        $sequence_3 = { 8b4da0 e9???????? c3 8b542408 8d420c 8b4aa0 33c8 }
            // n = 7, score = 100
            //   8b4da0               | mov                 ecx, dword ptr [ebp - 0x60]
            //   e9????????           |                     
            //   c3                   | ret                 
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   8d420c               | lea                 eax, [edx + 0xc]
            //   8b4aa0               | mov                 ecx, dword ptr [edx - 0x60]
            //   33c8                 | xor                 ecx, eax

        $sequence_4 = { 8b8528e5ffff 8b0485e86a0210 ff3401 ff15???????? 85c0 741e 8b8d40e5ffff }
            // n = 7, score = 100
            //   8b8528e5ffff         | mov                 eax, dword ptr [ebp - 0x1ad8]
            //   8b0485e86a0210       | mov                 eax, dword ptr [eax*4 + 0x10026ae8]
            //   ff3401               | push                dword ptr [ecx + eax]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   741e                 | je                  0x20
            //   8b8d40e5ffff         | mov                 ecx, dword ptr [ebp - 0x1ac0]

        $sequence_5 = { c78510ffffff07000000 837dd010 668985fcfeffff 89850cffffff 720b ff75bc e8???????? }
            // n = 7, score = 100
            //   c78510ffffff07000000     | mov    dword ptr [ebp - 0xf0], 7
            //   837dd010             | cmp                 dword ptr [ebp - 0x30], 0x10
            //   668985fcfeffff       | mov                 word ptr [ebp - 0x104], ax
            //   89850cffffff         | mov                 dword ptr [ebp - 0xf4], eax
            //   720b                 | jb                  0xd
            //   ff75bc               | push                dword ptr [ebp - 0x44]
            //   e8????????           |                     

        $sequence_6 = { 0f8455fdffff 837dd010 8d8d68feffff 6a00 51 ff75cc }
            // n = 6, score = 100
            //   0f8455fdffff         | je                  0xfffffd5b
            //   837dd010             | cmp                 dword ptr [ebp - 0x30], 0x10
            //   8d8d68feffff         | lea                 ecx, [ebp - 0x198]
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   ff75cc               | push                dword ptr [ebp - 0x34]

        $sequence_7 = { 68???????? b9???????? e8???????? 33c0 c645fc1f }
            // n = 5, score = 100
            //   68????????           |                     
            //   b9????????           |                     
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   c645fc1f             | mov                 byte ptr [ebp - 4], 0x1f

        $sequence_8 = { 8d8dd0fbffff e8???????? 8d8de8fbffff e8???????? 8d4d08 e8???????? }
            // n = 6, score = 100
            //   8d8dd0fbffff         | lea                 ecx, [ebp - 0x430]
            //   e8????????           |                     
            //   8d8de8fbffff         | lea                 ecx, [ebp - 0x418]
            //   e8????????           |                     
            //   8d4d08               | lea                 ecx, [ebp + 8]
            //   e8????????           |                     

        $sequence_9 = { 8d4d08 e9???????? 8d8de8fbffff e9???????? 8d8dd0fbffff e9???????? }
            // n = 6, score = 100
            //   8d4d08               | lea                 ecx, [ebp + 8]
            //   e9????????           |                     
            //   8d8de8fbffff         | lea                 ecx, [ebp - 0x418]
            //   e9????????           |                     
            //   8d8dd0fbffff         | lea                 ecx, [ebp - 0x430]
            //   e9????????           |                     

    condition:
        7 of them and filesize < 335872
}