rule win_alphanc_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.alphanc."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.alphanc"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bda 81e3ff000000 8b1c9d18c54c00 81e3ff000000 33fb 8b5e04 33fb }
            // n = 7, score = 100
            //   8bda                 | mov                 ebx, edx
            //   81e3ff000000         | and                 ebx, 0xff
            //   8b1c9d18c54c00       | mov                 ebx, dword ptr [ebx*4 + 0x4cc518]
            //   81e3ff000000         | and                 ebx, 0xff
            //   33fb                 | xor                 edi, ebx
            //   8b5e04               | mov                 ebx, dword ptr [esi + 4]
            //   33fb                 | xor                 edi, ebx

        $sequence_1 = { 8d54245c 6a1a 52 e8???????? 8d7c2464 83c9ff 33c0 }
            // n = 7, score = 100
            //   8d54245c             | lea                 edx, [esp + 0x5c]
            //   6a1a                 | push                0x1a
            //   52                   | push                edx
            //   e8????????           |                     
            //   8d7c2464             | lea                 edi, [esp + 0x64]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax

        $sequence_2 = { 8b542420 8bd8 8d4601 50 52 53 e8???????? }
            // n = 7, score = 100
            //   8b542420             | mov                 edx, dword ptr [esp + 0x20]
            //   8bd8                 | mov                 ebx, eax
            //   8d4601               | lea                 eax, [esi + 1]
            //   50                   | push                eax
            //   52                   | push                edx
            //   53                   | push                ebx
            //   e8????????           |                     

        $sequence_3 = { a1???????? 83c410 85c0 0f85d7000000 68ca010000 68???????? 6a10 }
            // n = 7, score = 100
            //   a1????????           |                     
            //   83c410               | add                 esp, 0x10
            //   85c0                 | test                eax, eax
            //   0f85d7000000         | jne                 0xdd
            //   68ca010000           | push                0x1ca
            //   68????????           |                     
            //   6a10                 | push                0x10

        $sequence_4 = { e8???????? 3bc7 89442420 750d c744241041000000 e9???????? 8b442438 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   3bc7                 | cmp                 eax, edi
            //   89442420             | mov                 dword ptr [esp + 0x20], eax
            //   750d                 | jne                 0xf
            //   c744241041000000     | mov                 dword ptr [esp + 0x10], 0x41
            //   e9????????           |                     
            //   8b442438             | mov                 eax, dword ptr [esp + 0x38]

        $sequence_5 = { 741d 03d6 52 51 50 e8???????? 8b54242c }
            // n = 7, score = 100
            //   741d                 | je                  0x1f
            //   03d6                 | add                 edx, esi
            //   52                   | push                edx
            //   51                   | push                ecx
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b54242c             | mov                 edx, dword ptr [esp + 0x2c]

        $sequence_6 = { 8d9424ec000000 85d2 7421 8d8424ec000000 53 50 e8???????? }
            // n = 7, score = 100
            //   8d9424ec000000       | lea                 edx, [esp + 0xec]
            //   85d2                 | test                edx, edx
            //   7421                 | je                  0x23
            //   8d8424ec000000       | lea                 eax, [esp + 0xec]
            //   53                   | push                ebx
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_7 = { 8bc5 5f 5e 5d 5b c3 6893000000 }
            // n = 7, score = 100
            //   8bc5                 | mov                 eax, ebp
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   6893000000           | push                0x93

        $sequence_8 = { c3 8b5558 8d4c2458 51 c644241741 899a74030000 8b4558 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   8b5558               | mov                 edx, dword ptr [ebp + 0x58]
            //   8d4c2458             | lea                 ecx, [esp + 0x58]
            //   51                   | push                ecx
            //   c644241741           | mov                 byte ptr [esp + 0x17], 0x41
            //   899a74030000         | mov                 dword ptr [edx + 0x374], ebx
            //   8b4558               | mov                 eax, dword ptr [ebp + 0x58]

        $sequence_9 = { c1e205 6a08 8d8a20074e00 51 53 53 }
            // n = 6, score = 100
            //   c1e205               | shl                 edx, 5
            //   6a08                 | push                8
            //   8d8a20074e00         | lea                 ecx, [edx + 0x4e0720]
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 2015232
}