rule win_andardoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.andardoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.andardoor"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 48895c2430 895c2428 c744242001000000 c745bc01010000 }
            // n = 4, score = 200
            //   48895c2430           | dec                 ebp
            //   895c2428             | mov                 edi, dword ptr [edi + esi*8 + 0x18de0]
            //   c744242001000000     | dec                 eax
            //   c745bc01010000       | cmp                 ebx, edi

        $sequence_1 = { 3bc3 7d15 4863d3 41b842000000 488bcf ff15???????? }
            // n = 6, score = 200
            //   3bc3                 | mov                 dword ptr [esp + 0x28], esi
            //   7d15                 | dec                 esp
            //   4863d3               | mov                 dword ptr [esp + 0x20], esi
            //   41b842000000         | test                eax, eax
            //   488bcf               | je                  0x488
            //   ff15????????         |                     

        $sequence_2 = { e8???????? 84c0 7414 85ff 7e10 448bc7 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   84c0                 | je                  0x12d
            //   7414                 | dec                 eax
            //   85ff                 | lea                 eax, [0x115b9]
            //   7e10                 | dec                 eax
            //   448bc7               | cmp                 ecx, eax

        $sequence_3 = { 48ffc3 48ffc1 8803 84c0 75f2 33ff 807d8000 }
            // n = 7, score = 200
            //   48ffc3               | mov                 dword ptr [esp + 8], ebx
            //   48ffc1               | dec                 eax
            //   8803                 | mov                 dword ptr [esp + 0x10], ebp
            //   84c0                 | dec                 eax
            //   75f2                 | mov                 dword ptr [esp + 0x18], esi
            //   33ff                 | push                edi
            //   807d8000             | dec                 eax

        $sequence_4 = { 7505 4032ff eb1f 85db }
            // n = 4, score = 200
            //   7505                 | lea                 ecx, [0x1d1e7]
            //   4032ff               | xor                 ecx, ecx
            //   eb1f                 | test                eax, eax
            //   85db                 | dec                 eax

        $sequence_5 = { 41b880000000 e8???????? 4533c9 4c8d442430 }
            // n = 4, score = 200
            //   41b880000000         | mov                 edi, edx
            //   e8????????           |                     
            //   4533c9               | cmp                 ecx, eax
            //   4c8d442430           | jne                 0x260

        $sequence_6 = { 448935???????? b932000000 ff15???????? 4439742440 0f86f5000000 }
            // n = 5, score = 200
            //   448935????????       |                     
            //   b932000000           | inc                 esp
            //   ff15????????         |                     
            //   4439742440           | mov                 eax, ebx
            //   0f86f5000000         | dec                 eax

        $sequence_7 = { 41be01000000 4889bc2410040000 4585f7 0f84c6010000 }
            // n = 4, score = 200
            //   41be01000000         | cmp                 ebx, edi
            //   4889bc2410040000     | jl                  0xbe
            //   4585f7               | mov                 eax, ebx
            //   0f84c6010000         | dec                 eax

        $sequence_8 = { 6685c0 75e7 33d2 488d8d50040000 41b880000000 e8???????? }
            // n = 6, score = 200
            //   6685c0               | inc                 ecx
            //   75e7                 | mov                 eax, 8
            //   33d2                 | dec                 eax
            //   488d8d50040000       | arpl                bx, ax
            //   41b880000000         | dec                 eax
            //   e8????????           |                     

        $sequence_9 = { 4883c002 4883f80a 75d6 e8???????? 488b4b08 4885c9 7405 }
            // n = 7, score = 200
            //   4883c002             | test                ebx, ebx
            //   4883f80a             | xor                 bl, 1
            //   75d6                 | jne                 0x1136
            //   e8????????           |                     
            //   488b4b08             | xor                 al, al
            //   4885c9               | jmp                 0x11b2
            //   7405                 | dec                 eax

    condition:
        7 of them and filesize < 339968
}