rule win_andromut_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.andromut."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.andromut"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7204 8b0e eb02 8bce 807c01fe3d 7501 4a }
            // n = 7, score = 200
            //   7204                 | jb                  6
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   eb02                 | jmp                 4
            //   8bce                 | mov                 ecx, esi
            //   807c01fe3d           | cmp                 byte ptr [ecx + eax - 2], 0x3d
            //   7501                 | jne                 3
            //   4a                   | dec                 edx

        $sequence_1 = { 8bf9 897de4 33db 895dfc 68???????? 895dec e8???????? }
            // n = 7, score = 200
            //   8bf9                 | mov                 edi, ecx
            //   897de4               | mov                 dword ptr [ebp - 0x1c], edi
            //   33db                 | xor                 ebx, ebx
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   68????????           |                     
            //   895dec               | mov                 dword ptr [ebp - 0x14], ebx
            //   e8????????           |                     

        $sequence_2 = { 03c2 83f037 f7d0 83f03b 8bc8 c1e004 c1e904 }
            // n = 7, score = 200
            //   03c2                 | add                 eax, edx
            //   83f037               | xor                 eax, 0x37
            //   f7d0                 | not                 eax
            //   83f03b               | xor                 eax, 0x3b
            //   8bc8                 | mov                 ecx, eax
            //   c1e004               | shl                 eax, 4
            //   c1e904               | shr                 ecx, 4

        $sequence_3 = { 8bc1 c1e106 c1e80a 83e03f 0bc1 }
            // n = 5, score = 200
            //   8bc1                 | mov                 eax, ecx
            //   c1e106               | shl                 ecx, 6
            //   c1e80a               | shr                 eax, 0xa
            //   83e03f               | and                 eax, 0x3f
            //   0bc1                 | or                  eax, ecx

        $sequence_4 = { 3dc8000000 756c 33f6 8d8dc8f3ffff }
            // n = 4, score = 200
            //   3dc8000000           | cmp                 eax, 0xc8
            //   756c                 | jne                 0x6e
            //   33f6                 | xor                 esi, esi
            //   8d8dc8f3ffff         | lea                 ecx, [ebp - 0xc38]

        $sequence_5 = { 50 8d85b8ebffff 50 8d8d40e3ffff e8???????? 83bd54e3ffff10 8db540e3ffff }
            // n = 7, score = 200
            //   50                   | push                eax
            //   8d85b8ebffff         | lea                 eax, [ebp - 0x1448]
            //   50                   | push                eax
            //   8d8d40e3ffff         | lea                 ecx, [ebp - 0x1cc0]
            //   e8????????           |                     
            //   83bd54e3ffff10       | cmp                 dword ptr [ebp - 0x1cac], 0x10
            //   8db540e3ffff         | lea                 esi, [ebp - 0x1cc0]

        $sequence_6 = { 83c202 663bc6 75f5 2bd1 d1fa 52 56 }
            // n = 7, score = 200
            //   83c202               | add                 edx, 2
            //   663bc6               | cmp                 ax, si
            //   75f5                 | jne                 0xfffffff7
            //   2bd1                 | sub                 edx, ecx
            //   d1fa                 | sar                 edx, 1
            //   52                   | push                edx
            //   56                   | push                esi

        $sequence_7 = { 8bd0 8d4d90 e8???????? 85ff 7e52 897d84 8b7d88 }
            // n = 7, score = 200
            //   8bd0                 | mov                 edx, eax
            //   8d4d90               | lea                 ecx, [ebp - 0x70]
            //   e8????????           |                     
            //   85ff                 | test                edi, edi
            //   7e52                 | jle                 0x54
            //   897d84               | mov                 dword ptr [ebp - 0x7c], edi
            //   8b7d88               | mov                 edi, dword ptr [ebp - 0x78]

        $sequence_8 = { 0fb6c0 0f45c8 3255ff 324dfd 324df4 880e 8aca }
            // n = 7, score = 200
            //   0fb6c0               | movzx               eax, al
            //   0f45c8               | cmovne              ecx, eax
            //   3255ff               | xor                 dl, byte ptr [ebp - 1]
            //   324dfd               | xor                 cl, byte ptr [ebp - 3]
            //   324df4               | xor                 cl, byte ptr [ebp - 0xc]
            //   880e                 | mov                 byte ptr [esi], cl
            //   8aca                 | mov                 cl, dl

        $sequence_9 = { b9daf68a50 ab 66ab e8???????? 56 6880000000 }
            // n = 6, score = 200
            //   b9daf68a50           | mov                 ecx, 0x508af6da
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   e8????????           |                     
            //   56                   | push                esi
            //   6880000000           | push                0x80

    condition:
        7 of them and filesize < 368640
}