rule win_applejeus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.applejeus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.applejeus"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8885b3fbffff 8b8598fbffff 0418 83f059 8885b4fbffff 8b8598fbffff 0419 }
            // n = 7, score = 200
            //   8885b3fbffff         | mov                 byte ptr [ebp - 0x44d], al
            //   8b8598fbffff         | mov                 eax, dword ptr [ebp - 0x468]
            //   0418                 | add                 al, 0x18
            //   83f059               | xor                 eax, 0x59
            //   8885b4fbffff         | mov                 byte ptr [ebp - 0x44c], al
            //   8b8598fbffff         | mov                 eax, dword ptr [ebp - 0x468]
            //   0419                 | add                 al, 0x19

        $sequence_1 = { 8b0f 8901 ffd6 8b4f04 0f57c0 660fd645e0 c745e000000000 }
            // n = 7, score = 200
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   8901                 | mov                 dword ptr [ecx], eax
            //   ffd6                 | call                esi
            //   8b4f04               | mov                 ecx, dword ptr [edi + 4]
            //   0f57c0               | xorps               xmm0, xmm0
            //   660fd645e0           | movq                qword ptr [ebp - 0x20], xmm0
            //   c745e000000000       | mov                 dword ptr [ebp - 0x20], 0

        $sequence_2 = { 8bce ff10 6a04 56 e8???????? 6a04 ff7598 }
            // n = 7, score = 200
            //   8bce                 | mov                 ecx, esi
            //   ff10                 | call                dword ptr [eax]
            //   6a04                 | push                4
            //   56                   | push                esi
            //   e8????????           |                     
            //   6a04                 | push                4
            //   ff7598               | push                dword ptr [ebp - 0x68]

        $sequence_3 = { 8b85e4edffff c645fc0b 8b7f28 89bd40eeffff 8dbdf0efffff 8b7024 8b5020 }
            // n = 7, score = 200
            //   8b85e4edffff         | mov                 eax, dword ptr [ebp - 0x121c]
            //   c645fc0b             | mov                 byte ptr [ebp - 4], 0xb
            //   8b7f28               | mov                 edi, dword ptr [edi + 0x28]
            //   89bd40eeffff         | mov                 dword ptr [ebp - 0x11c0], edi
            //   8dbdf0efffff         | lea                 edi, [ebp - 0x1010]
            //   8b7024               | mov                 esi, dword ptr [eax + 0x24]
            //   8b5020               | mov                 edx, dword ptr [eax + 0x20]

        $sequence_4 = { c685a1e7ffff43 c685a2e7ffff52 c685a3e7ffff66 8a8570e7ffff c685a4e7ffff00 0f1f4000 }
            // n = 6, score = 200
            //   c685a1e7ffff43       | mov                 byte ptr [ebp - 0x185f], 0x43
            //   c685a2e7ffff52       | mov                 byte ptr [ebp - 0x185e], 0x52
            //   c685a3e7ffff66       | mov                 byte ptr [ebp - 0x185d], 0x66
            //   8a8570e7ffff         | mov                 al, byte ptr [ebp - 0x1890]
            //   c685a4e7ffff00       | mov                 byte ptr [ebp - 0x185c], 0
            //   0f1f4000             | nop                 dword ptr [eax]

        $sequence_5 = { 042f 83f06c 88852ffeffff 8b85fcfdffff 0430 83f04d 888530feffff }
            // n = 7, score = 200
            //   042f                 | add                 al, 0x2f
            //   83f06c               | xor                 eax, 0x6c
            //   88852ffeffff         | mov                 byte ptr [ebp - 0x1d1], al
            //   8b85fcfdffff         | mov                 eax, dword ptr [ebp - 0x204]
            //   0430                 | add                 al, 0x30
            //   83f04d               | xor                 eax, 0x4d
            //   888530feffff         | mov                 byte ptr [ebp - 0x1d0], al

        $sequence_6 = { ffd3 8b4d08 83c410 894104 8b450c 5f 5e }
            // n = 7, score = 200
            //   ffd3                 | call                ebx
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   83c410               | add                 esp, 0x10
            //   894104               | mov                 dword ptr [ecx + 4], eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_7 = { 8955c4 8b461c 8945d0 e8???????? 0f1045bc 8b4dd8 83c408 }
            // n = 7, score = 200
            //   8955c4               | mov                 dword ptr [ebp - 0x3c], edx
            //   8b461c               | mov                 eax, dword ptr [esi + 0x1c]
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   e8????????           |                     
            //   0f1045bc             | movups              xmm0, xmmword ptr [ebp - 0x44]
            //   8b4dd8               | mov                 ecx, dword ptr [ebp - 0x28]
            //   83c408               | add                 esp, 8

        $sequence_8 = { e8???????? 50 8d4de0 e8???????? 8d45e0 50 8d8d9cfeffff }
            // n = 7, score = 200
            //   e8????????           |                     
            //   50                   | push                eax
            //   8d4de0               | lea                 ecx, [ebp - 0x20]
            //   e8????????           |                     
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax
            //   8d8d9cfeffff         | lea                 ecx, [ebp - 0x164]

        $sequence_9 = { 8885c9f6ffff 8b8560f6ffff 0466 83f053 8885caf6ffff 8b8560f6ffff 0467 }
            // n = 7, score = 200
            //   8885c9f6ffff         | mov                 byte ptr [ebp - 0x937], al
            //   8b8560f6ffff         | mov                 eax, dword ptr [ebp - 0x9a0]
            //   0466                 | add                 al, 0x66
            //   83f053               | xor                 eax, 0x53
            //   8885caf6ffff         | mov                 byte ptr [ebp - 0x936], al
            //   8b8560f6ffff         | mov                 eax, dword ptr [ebp - 0x9a0]
            //   0467                 | add                 al, 0x67

    condition:
        7 of them and filesize < 1245184
}