rule win_appleseed_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.appleseed."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.appleseed"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4881ecf0010000 48c745d8feffffff 48895810 48897018 488b05???????? }
            // n = 5, score = 100
            //   4881ecf0010000       | ret                 
            //   48c745d8feffffff     | dec                 eax
            //   48895810             | lea                 edx, [0x2cb74]
            //   48897018             | mov                 eax, ecx
            //   488b05????????       |                     

        $sequence_1 = { e8???????? 48833d????????00 0f842e020000 488d150c170200 488d4db8 e8???????? 90 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   48833d????????00     |                     
            //   0f842e020000         | mov                 edx, edi
            //   488d150c170200       | inc                 esp
            //   488d4db8             | mov                 eax, dword ptr [ecx + edi*4 + 0x2c3b0]
            //   e8????????           |                     
            //   90                   | inc                 ebp

        $sequence_2 = { 7367 4863d9 4c8d357a640100 488bfb 83e31f 48c1ff05 }
            // n = 6, score = 100
            //   7367                 | dec                 eax
            //   4863d9               | xor                 ecx, esp
            //   4c8d357a640100       | dec                 eax
            //   488bfb               | cmp                 dword ptr [ebp + 0xd8], 0x10
            //   83e31f               | dec                 eax
            //   48c1ff05             | cmovae              edx, dword ptr [ebp + 0xc0]

        $sequence_3 = { 85c0 74ac 488d15b2e10100 488bcb e8???????? 85c0 7499 }
            // n = 7, score = 100
            //   85c0                 | mov                 ecx, eax
            //   74ac                 | je                  0x492
            //   488d15b2e10100       | inc                 esp
            //   488bcb               | mov                 dword ptr [ebp + 0xa0], esi
            //   e8????????           |                     
            //   85c0                 | dec                 eax
            //   7499                 | lea                 edx, [ebp + 0x80]

        $sequence_4 = { 817d0063736de0 7528 48833d????????00 741e 488d0da9000100 e8???????? }
            // n = 6, score = 100
            //   817d0063736de0       | mov                 byte ptr [ebp + 0x20], 0
            //   7528                 | xor                 edx, edx
            //   48833d????????00     |                     
            //   741e                 | inc                 ecx
            //   488d0da9000100       | mov                 eax, 0x3ff
            //   e8????????           |                     

        $sequence_5 = { 488bf0 4889442478 4885c0 7506 }
            // n = 4, score = 100
            //   488bf0               | lea                 ecx, [0xfffe8f05]
            //   4889442478           | dec                 eax
            //   4885c0               | test                esi, esi
            //   7506                 | jle                 0xf3f

        $sequence_6 = { 48898540010000 48c745d80f000000 488975d0 c645c000 4d8bce 4533c0 498bd4 }
            // n = 7, score = 100
            //   48898540010000       | dec                 eax
            //   48c745d80f000000     | mov                 dword ptr [esp + 0x78], 0xf
            //   488975d0             | dec                 eax
            //   c645c000             | mov                 dword ptr [esp + 0x70], esi
            //   4d8bce               | mov                 byte ptr [esp + 0x60], 0
            //   4533c0               | dec                 eax
            //   498bd4               | cmp                 dword ptr [esp + 0x58], 0x10

        $sequence_7 = { 48833d????????00 0f8404040000 488d1552170200 488d4db8 e8???????? 90 488d55d8 }
            // n = 7, score = 100
            //   48833d????????00     |                     
            //   0f8404040000         | dec                 eax
            //   488d1552170200       | lea                 ecx, [ebp - 0x80]
            //   488d4db8             | nop                 
            //   e8????????           |                     
            //   90                   | dec                 eax
            //   488d55d8             | mov                 dword ptr [ebp - 0x40], esi

        $sequence_8 = { e9???????? 488d8af0000000 e9???????? 488b8a60000000 e9???????? 488d8a10010000 e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488d8af0000000       | mov                 dword ptr [ebp + 0x30], eax
            //   e9????????           |                     
            //   488b8a60000000       | inc                 ebp
            //   e9????????           |                     
            //   488d8a10010000       | mov                 esi, eax
            //   e9????????           |                     

        $sequence_9 = { 488d4b04 4c8d05df770000 418d5216 e8???????? 85c0 0f8544090000 }
            // n = 6, score = 100
            //   488d4b04             | dec                 eax
            //   4c8d05df770000       | lea                 ecx, [edx + 0x140]
            //   418d5216             | dec                 eax
            //   e8????????           |                     
            //   85c0                 | mov                 ecx, dword ptr [edx + 0x40]
            //   0f8544090000         | dec                 eax

    condition:
        7 of them and filesize < 497664
}