rule win_athenago_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.athenago"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 896c243c 89442438 31db 895c2428 895c242c 31ed 39e8 }
            // n = 7, score = 100
            //   896c243c             | mov                 dword ptr [esp + 0x3c], ebp
            //   89442438             | mov                 dword ptr [esp + 0x38], eax
            //   31db                 | xor                 ebx, ebx
            //   895c2428             | mov                 dword ptr [esp + 0x28], ebx
            //   895c242c             | mov                 dword ptr [esp + 0x2c], ebx
            //   31ed                 | xor                 ebp, ebp
            //   39e8                 | cmp                 eax, ebp

        $sequence_1 = { 8b5c2410 895c242c 8b442414 8b5c2418 895c2424 89442420 83f800 }
            // n = 7, score = 100
            //   8b5c2410             | mov                 ebx, dword ptr [esp + 0x10]
            //   895c242c             | mov                 dword ptr [esp + 0x2c], ebx
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   8b5c2418             | mov                 ebx, dword ptr [esp + 0x18]
            //   895c2424             | mov                 dword ptr [esp + 0x24], ebx
            //   89442420             | mov                 dword ptr [esp + 0x20], eax
            //   83f800               | cmp                 eax, 0

        $sequence_2 = { 8b5c2454 895c2404 8b5c2458 895c2408 e8???????? 8b4c240c 8b442410 }
            // n = 7, score = 100
            //   8b5c2454             | mov                 ebx, dword ptr [esp + 0x54]
            //   895c2404             | mov                 dword ptr [esp + 4], ebx
            //   8b5c2458             | mov                 ebx, dword ptr [esp + 0x58]
            //   895c2408             | mov                 dword ptr [esp + 8], ebx
            //   e8????????           |                     
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]

        $sequence_3 = { 39c1 7721 89bc2488000000 898c248c000000 89842490000000 c684249400000001 83c478 }
            // n = 7, score = 100
            //   39c1                 | cmp                 ecx, eax
            //   7721                 | ja                  0x23
            //   89bc2488000000       | mov                 dword ptr [esp + 0x88], edi
            //   898c248c000000       | mov                 dword ptr [esp + 0x8c], ecx
            //   89842490000000       | mov                 dword ptr [esp + 0x90], eax
            //   c684249400000001     | mov                 byte ptr [esp + 0x94], 1
            //   83c478               | add                 esp, 0x78

        $sequence_4 = { 8b5c242c 83fb7a 7547 8b442454 8b5c2424 39d8 7236 }
            // n = 7, score = 100
            //   8b5c242c             | mov                 ebx, dword ptr [esp + 0x2c]
            //   83fb7a               | cmp                 ebx, 0x7a
            //   7547                 | jne                 0x49
            //   8b442454             | mov                 eax, dword ptr [esp + 0x54]
            //   8b5c2424             | mov                 ebx, dword ptr [esp + 0x24]
            //   39d8                 | cmp                 eax, ebx
            //   7236                 | jb                  0x38

        $sequence_5 = { 31db 895c2440 895c2444 894c2448 }
            // n = 4, score = 100
            //   31db                 | xor                 ebx, ebx
            //   895c2440             | mov                 dword ptr [esp + 0x40], ebx
            //   895c2444             | mov                 dword ptr [esp + 0x44], ebx
            //   894c2448             | mov                 dword ptr [esp + 0x48], ecx

        $sequence_6 = { 891c24 8b5c2474 895c2404 e8???????? 8b6c2408 8b54240c 8b4c2410 }
            // n = 7, score = 100
            //   891c24               | mov                 dword ptr [esp], ebx
            //   8b5c2474             | mov                 ebx, dword ptr [esp + 0x74]
            //   895c2404             | mov                 dword ptr [esp + 4], ebx
            //   e8????????           |                     
            //   8b6c2408             | mov                 ebp, dword ptr [esp + 8]
            //   8b54240c             | mov                 edx, dword ptr [esp + 0xc]
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]

        $sequence_7 = { 731a 01c6 881e 40 39f8 7cdc 897918 }
            // n = 7, score = 100
            //   731a                 | jae                 0x1c
            //   01c6                 | add                 esi, eax
            //   881e                 | mov                 byte ptr [esi], bl
            //   40                   | inc                 eax
            //   39f8                 | cmp                 eax, edi
            //   7cdc                 | jl                  0xffffffde
            //   897918               | mov                 dword ptr [ecx + 0x18], edi

        $sequence_8 = { 895c2410 8b9c24d8000000 895c2414 e8???????? 8b9c2408010000 891c24 8b9c240c010000 }
            // n = 7, score = 100
            //   895c2410             | mov                 dword ptr [esp + 0x10], ebx
            //   8b9c24d8000000       | mov                 ebx, dword ptr [esp + 0xd8]
            //   895c2414             | mov                 dword ptr [esp + 0x14], ebx
            //   e8????????           |                     
            //   8b9c2408010000       | mov                 ebx, dword ptr [esp + 0x108]
            //   891c24               | mov                 dword ptr [esp], ebx
            //   8b9c240c010000       | mov                 ebx, dword ptr [esp + 0x10c]

        $sequence_9 = { 83f809 0f845bfdffff 83f80a 0f8452fdffff 83f80b 0f8449fdffff e9???????? }
            // n = 7, score = 100
            //   83f809               | cmp                 eax, 9
            //   0f845bfdffff         | je                  0xfffffd61
            //   83f80a               | cmp                 eax, 0xa
            //   0f8452fdffff         | je                  0xfffffd58
            //   83f80b               | cmp                 eax, 0xb
            //   0f8449fdffff         | je                  0xfffffd4f
            //   e9????????           |                     

    condition:
        7 of them and filesize < 13680640
}