rule win_atmosphere_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.atmosphere."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.atmosphere"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bf1 57 ff15???????? 8b470c 89460c }
            // n = 5, score = 400
            //   8bf1                 | mov                 esi, ecx
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8b470c               | mov                 eax, dword ptr [edi + 0xc]
            //   89460c               | mov                 dword ptr [esi + 0xc], eax

        $sequence_1 = { 83ec14 56 8b7104 85f6 }
            // n = 4, score = 400
            //   83ec14               | sub                 esp, 0x14
            //   56                   | push                esi
            //   8b7104               | mov                 esi, dword ptr [ecx + 4]
            //   85f6                 | test                esi, esi

        $sequence_2 = { 8bf9 8b06 8bce 8b1f ff5004 }
            // n = 5, score = 400
            //   8bf9                 | mov                 edi, ecx
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8bce                 | mov                 ecx, esi
            //   8b1f                 | mov                 ebx, dword ptr [edi]
            //   ff5004               | call                dword ptr [eax + 4]

        $sequence_3 = { 56 57 33db 8bf1 8965f0 }
            // n = 5, score = 400
            //   56                   | push                esi
            //   57                   | push                edi
            //   33db                 | xor                 ebx, ebx
            //   8bf1                 | mov                 esi, ecx
            //   8965f0               | mov                 dword ptr [ebp - 0x10], esp

        $sequence_4 = { 83ec10 c645fc02 8bcc 8965e8 50 51 e8???????? }
            // n = 7, score = 400
            //   83ec10               | sub                 esp, 0x10
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2
            //   8bcc                 | mov                 ecx, esp
            //   8965e8               | mov                 dword ptr [ebp - 0x18], esp
            //   50                   | push                eax
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_5 = { 8b7c240c 8bf1 57 ff15???????? 8b470c 89460c }
            // n = 6, score = 400
            //   8b7c240c             | mov                 edi, dword ptr [esp + 0xc]
            //   8bf1                 | mov                 esi, ecx
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8b470c               | mov                 eax, dword ptr [edi + 0xc]
            //   89460c               | mov                 dword ptr [esi + 0xc], eax

        $sequence_6 = { 53 56 57 33db 8bf1 8965f0 }
            // n = 6, score = 400
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   33db                 | xor                 ebx, ebx
            //   8bf1                 | mov                 esi, ecx
            //   8965f0               | mov                 dword ptr [ebp - 0x10], esp

        $sequence_7 = { 6a04 50 8b11 ff12 }
            // n = 4, score = 400
            //   6a04                 | push                4
            //   50                   | push                eax
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   ff12                 | call                dword ptr [edx]

        $sequence_8 = { 88460e 33c0 894612 894616 }
            // n = 4, score = 400
            //   88460e               | mov                 byte ptr [esi + 0xe], al
            //   33c0                 | xor                 eax, eax
            //   894612               | mov                 dword ptr [esi + 0x12], eax
            //   894616               | mov                 dword ptr [esi + 0x16], eax

        $sequence_9 = { 56 57 8bf9 6a2e e8???????? 8bf0 }
            // n = 6, score = 400
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf9                 | mov                 edi, ecx
            //   6a2e                 | push                0x2e
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax

    condition:
        7 of them and filesize < 360448
}