rule win_attor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.attor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.attor"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83f801 7411 3d81000000 740a }
            // n = 4, score = 400
            //   83f801               | cmp                 eax, 1
            //   7411                 | je                  0x13
            //   3d81000000           | cmp                 eax, 0x81
            //   740a                 | je                  0xc

        $sequence_1 = { 4c8bce 89442420 ff15???????? 85c0 750a }
            // n = 5, score = 300
            //   4c8bce               | mov                 ecx, edi
            //   89442420             | dec                 eax
            //   ff15????????         |                     
            //   85c0                 | mov                 dword ptr [edi], eax
            //   750a                 | dec                 eax

        $sequence_2 = { 740f 33c9 e8???????? 488bce e8???????? 488b742458 4d85ed }
            // n = 7, score = 300
            //   740f                 | mov                 dword ptr [edi + 8], eax
            //   33c9                 | dec                 eax
            //   e8????????           |                     
            //   488bce               | mov                 dword ptr [edi + 0x10], eax
            //   e8????????           |                     
            //   488b742458           | dec                 eax
            //   4d85ed               | mov                 dword ptr [edi + 0x18], eax

        $sequence_3 = { 488d4c2458 4889442458 e8???????? 4839742440 7457 b101 }
            // n = 6, score = 300
            //   488d4c2458           | mov                 ecx, esi
            //   4889442458           | dec                 eax
            //   e8????????           |                     
            //   4839742440           | mov                 esi, dword ptr [esp + 0x58]
            //   7457                 | dec                 ebp
            //   b101                 | test                ebp, ebp

        $sequence_4 = { e8???????? 488b4c2430 4c8bc5 33d2 e8???????? 488b4c2430 4885c9 }
            // n = 7, score = 300
            //   e8????????           |                     
            //   488b4c2430           | dec                 eax
            //   4c8bc5               | mov                 ecx, dword ptr [esp + 0x30]
            //   33d2                 | dec                 esp
            //   e8????????           |                     
            //   488b4c2430           | mov                 eax, ebp
            //   4885c9               | xor                 edx, edx

        $sequence_5 = { 488b8c2490000000 e8???????? 48c784249000000000000000 4d85f6 740f }
            // n = 5, score = 300
            //   488b8c2490000000     | dec                 eax
            //   e8????????           |                     
            //   48c784249000000000000000     | mov    dword ptr [esp + 0x40], ebx
            //   4d85f6               | dec                 esp
            //   740f                 | mov                 ebp, dword ptr [esp + 0x38]

        $sequence_6 = { 48895c2440 e8???????? 4c8b6c2438 4c8bf8 488b442440 }
            // n = 5, score = 300
            //   48895c2440           | dec                 esp
            //   e8????????           |                     
            //   4c8b6c2438           | mov                 ecx, esi
            //   4c8bf8               | mov                 dword ptr [esp + 0x20], eax
            //   488b442440           | test                eax, eax

        $sequence_7 = { eb78 33c0 488bcf 488907 48894708 48894710 48894718 }
            // n = 7, score = 300
            //   eb78                 | dec                 eax
            //   33c0                 | mov                 ecx, dword ptr [esp + 0x30]
            //   488bcf               | dec                 eax
            //   488907               | test                ecx, ecx
            //   48894708             | jmp                 0x7a
            //   48894710             | xor                 eax, eax
            //   48894718             | dec                 eax

        $sequence_8 = { 0f84c3000000 6a02 56 50 ff15???????? 85c0 }
            // n = 6, score = 200
            //   0f84c3000000         | je                  0x20
            //   6a02                 | jmp                 7
            //   56                   | mov                 ebx, 0x57
            //   50                   | dec                 esp
            //   ff15????????         |                     
            //   85c0                 | mov                 edi, dword ptr [esp + 0x40]

        $sequence_9 = { 740a 83f808 7405 83f811 }
            // n = 4, score = 200
            //   740a                 | dec                 eax
            //   83f808               | mov                 dword ptr [edi + 0x20], eax
            //   7405                 | test                eax, eax
            //   83f811               | jne                 0xe

        $sequence_10 = { 0f84cc020000 8d442438 897c2438 50 6a0c }
            // n = 5, score = 200
            //   0f84cc020000         | mov                 byte ptr [eax + 1], 3
            //   8d442438             | mov                 ecx, dword ptr [esp + 0x10]
            //   897c2438             | mov                 word ptr [ecx + 2], bx
            //   50                   | push                esi
            //   6a0c                 | call                ebx

        $sequence_11 = { 8d442420 8d4c2434 50 51 e8???????? }
            // n = 5, score = 200
            //   8d442420             | dec                 esp
            //   8d4c2434             | mov                 esi, dword ptr [esp + 0x48]
            //   50                   | je                  0xc
            //   51                   | cmp                 eax, 8
            //   e8????????           |                     

        $sequence_12 = { 6a00 e8???????? 8b54240c 52 }
            // n = 4, score = 200
            //   6a00                 | je                  0xa
            //   e8????????           |                     
            //   8b54240c             | cmp                 eax, 0x11
            //   52                   | shr                 ecx, 2

        $sequence_13 = { 56 ffd3 8944242c 8d542420 }
            // n = 4, score = 200
            //   56                   | dec                 eax
            //   ffd3                 | mov                 dword ptr [esp + 0x90], 0
            //   8944242c             | dec                 ebp
            //   8d542420             | test                esi, esi

        $sequence_14 = { 8b442410 c6400103 8b4c2410 66895902 }
            // n = 4, score = 200
            //   8b442410             | je                  0x63
            //   c6400103             | mov                 cl, 1
            //   8b4c2410             | dec                 eax
            //   66895902             | mov                 ecx, dword ptr [esp + 0x90]

        $sequence_15 = { c1e902 f3ab 8bca 83c404 83e103 f3aa 8b44241c }
            // n = 7, score = 200
            //   c1e902               | mov                 ebx, eax
            //   f3ab                 | dec                 eax
            //   8bca                 | lea                 ecx, [esp + 0x58]
            //   83c404               | dec                 eax
            //   83e103               | mov                 dword ptr [esp + 0x58], eax
            //   f3aa                 | dec                 eax
            //   8b44241c             | cmp                 dword ptr [esp + 0x40], esi

    condition:
        7 of them and filesize < 2023424
}