rule win_aukill_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.aukill."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.aukill"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8905???????? c705????????02000000 48c705????????04000000 ff15???????? }
            // n = 4, score = 200
            //   8905????????         |                     
            //   c705????????02000000     |     
            //   48c705????????04000000     |     
            //   ff15????????         |                     

        $sequence_1 = { 751d 488bcb ff15???????? ff15???????? }
            // n = 4, score = 200
            //   751d                 | lea                 edx, [0xee59]
            //   488bcb               | dec                 eax
            //   ff15????????         |                     
            //   ff15????????         |                     

        $sequence_2 = { 7410 488bcf e8???????? 33c9 ff15???????? }
            // n = 5, score = 200
            //   7410                 | mov                 dword ptr [ebp + 0x5b8], edi
            //   488bcf               | dec                 eax
            //   e8????????           |                     
            //   33c9                 | mov                 dword ptr [esp + 0x28], eax
            //   ff15????????         |                     

        $sequence_3 = { 4489442420 453b01 7346 4b8d1440 410f104cd108 }
            // n = 5, score = 200
            //   4489442420           | mov                 dword ptr [edi], eax
            //   453b01               | dec                 eax
            //   7346                 | lea                 edx, [esp + 0x30]
            //   4b8d1440             | mov                 dword ptr [esp + 0x20], ebx
            //   410f104cd108         | jmp                 0xff0

        $sequence_4 = { 488bd3 33c9 ff15???????? 85c0 751f 488b4c2458 ff15???????? }
            // n = 7, score = 200
            //   488bd3               | mov                 ecx, eax
            //   33c9                 | dec                 esp
            //   ff15????????         |                     
            //   85c0                 | lea                 edx, [0x11341]
            //   751f                 | and                 ecx, 0x3f
            //   488b4c2458           | dec                 ecx
            //   ff15????????         |                     

        $sequence_5 = { ff15???????? 488bf8 4885c0 7514 ff15???????? }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   488bf8               | lea                 ecx, [edx + 2]
            //   4885c0               | dec                 eax
            //   7514                 | mov                 edi, edx
            //   ff15????????         |                     

        $sequence_6 = { c744243c02000000 448d4810 4889442420 ff15???????? 85c0 751f 488b4c2458 }
            // n = 7, score = 200
            //   c744243c02000000     | mov                 eax, 0x10
            //   448d4810             | dec                 eax
            //   4889442420           | mov                 ecx, eax
            //   ff15????????         |                     
            //   85c0                 | xor                 edx, edx
            //   751f                 | xor                 ecx, ecx
            //   488b4c2458           | inc                 esp

        $sequence_7 = { 4533c0 33d2 33c9 ff15???????? 4885c0 7409 488bc8 }
            // n = 7, score = 200
            //   4533c0               | dec                 eax
            //   33d2                 | cmp                 dword ptr [eax - 0x10], edx
            //   33c9                 | je                  0x29b
            //   ff15????????         |                     
            //   4885c0               | dec                 eax
            //   7409                 | mov                 edx, dword ptr [eax]
            //   488bc8               | dec                 eax

        $sequence_8 = { 33c0 4889442428 c744243001000000 c744243c02000000 448d4810 4889442420 ff15???????? }
            // n = 7, score = 200
            //   33c0                 | je                  0x1b3c
            //   4889442428           | dec                 eax
            //   c744243001000000     | mov                 edx, edi
            //   c744243c02000000     | dec                 esp
            //   448d4810             | mov                 dword ptr [esp + 0x8d8], esi
            //   4889442420           | xor                 ecx, ecx
            //   ff15????????         |                     

        $sequence_9 = { 48894c2420 448d4920 48894c2450 488b0d???????? }
            // n = 4, score = 200
            //   48894c2420           | test                eax, eax
            //   448d4920             | jne                 0x728
            //   48894c2450           | inc                 ebp
            //   488b0d????????       |                     

    condition:
        7 of them and filesize < 446464
}