rule win_avcrypt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.avcrypt."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.avcrypt"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7467 663bdf 7462 837e4000 7515 ff7650 57 }
            // n = 7, score = 100
            //   7467                 | je                  0x69
            //   663bdf               | cmp                 bx, di
            //   7462                 | je                  0x64
            //   837e4000             | cmp                 dword ptr [esi + 0x40], 0
            //   7515                 | jne                 0x17
            //   ff7650               | push                dword ptr [esi + 0x50]
            //   57                   | push                edi

        $sequence_1 = { 57 56 8d4d38 e8???????? 57 56 8d4d50 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   56                   | push                esi
            //   8d4d38               | lea                 ecx, [ebp + 0x38]
            //   e8????????           |                     
            //   57                   | push                edi
            //   56                   | push                esi
            //   8d4d50               | lea                 ecx, [ebp + 0x50]

        $sequence_2 = { 85c9 0f88d9090000 8d42e0 3c58 770f 0fbec2 0fbe8058e34200 }
            // n = 7, score = 100
            //   85c9                 | test                ecx, ecx
            //   0f88d9090000         | js                  0x9df
            //   8d42e0               | lea                 eax, [edx - 0x20]
            //   3c58                 | cmp                 al, 0x58
            //   770f                 | ja                  0x11
            //   0fbec2               | movsx               eax, dl
            //   0fbe8058e34200       | movsx               eax, byte ptr [eax + 0x42e358]

        $sequence_3 = { e8???????? 59 0fb7c8 b8ffff0000 663bc8 0f8406010000 8bc1 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   0fb7c8               | movzx               ecx, ax
            //   b8ffff0000           | mov                 eax, 0xffff
            //   663bc8               | cmp                 cx, ax
            //   0f8406010000         | je                  0x10c
            //   8bc1                 | mov                 eax, ecx

        $sequence_4 = { 7447 8802 42 8b048d80b54300 4e 807d1301 }
            // n = 6, score = 100
            //   7447                 | je                  0x49
            //   8802                 | mov                 byte ptr [edx], al
            //   42                   | inc                 edx
            //   8b048d80b54300       | mov                 eax, dword ptr [ecx*4 + 0x43b580]
            //   4e                   | dec                 esi
            //   807d1301             | cmp                 byte ptr [ebp + 0x13], 1

        $sequence_5 = { 8d4d8c c645fc13 e8???????? 68???????? 8d4da4 c645fc14 }
            // n = 6, score = 100
            //   8d4d8c               | lea                 ecx, [ebp - 0x74]
            //   c645fc13             | mov                 byte ptr [ebp - 4], 0x13
            //   e8????????           |                     
            //   68????????           |                     
            //   8d4da4               | lea                 ecx, [ebp - 0x5c]
            //   c645fc14             | mov                 byte ptr [ebp - 4], 0x14

        $sequence_6 = { 75e2 8b7df4 8937 5e eb05 8b4510 }
            // n = 6, score = 100
            //   75e2                 | jne                 0xffffffe4
            //   8b7df4               | mov                 edi, dword ptr [ebp - 0xc]
            //   8937                 | mov                 dword ptr [edi], esi
            //   5e                   | pop                 esi
            //   eb05                 | jmp                 7
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]

        $sequence_7 = { 895dfc 894dbc 895db8 668945a8 894dd4 895dd0 668945c0 }
            // n = 7, score = 100
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   894dbc               | mov                 dword ptr [ebp - 0x44], ecx
            //   895db8               | mov                 dword ptr [ebp - 0x48], ebx
            //   668945a8             | mov                 word ptr [ebp - 0x58], ax
            //   894dd4               | mov                 dword ptr [ebp - 0x2c], ecx
            //   895dd0               | mov                 dword ptr [ebp - 0x30], ebx
            //   668945c0             | mov                 word ptr [ebp - 0x40], ax

        $sequence_8 = { 8d45d8 0f4345d8 57 50 57 }
            // n = 5, score = 100
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   0f4345d8             | cmovae              eax, dword ptr [ebp - 0x28]
            //   57                   | push                edi
            //   50                   | push                eax
            //   57                   | push                edi

        $sequence_9 = { 8bc6 e8???????? c20400 8b11 83c9ff 83ea10 8d420c }
            // n = 7, score = 100
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     
            //   c20400               | ret                 4
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   83ea10               | sub                 edx, 0x10
            //   8d420c               | lea                 eax, [edx + 0xc]

    condition:
        7 of them and filesize < 6160384
}