rule win_ave_maria_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ave_maria."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ave_maria"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8165e800ff00ff c1c008 25ff00ff00 894df8 0945e8 8bc7 33c2 }
            // n = 7, score = 400
            //   8165e800ff00ff       | and                 dword ptr [ebp - 0x18], 0xff00ff00
            //   c1c008               | rol                 eax, 8
            //   25ff00ff00           | and                 eax, 0xff00ff
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   0945e8               | or                  dword ptr [ebp - 0x18], eax
            //   8bc7                 | mov                 eax, edi
            //   33c2                 | xor                 eax, edx

        $sequence_1 = { 8bcf e8???????? 8d4de0 e8???????? 33f6 e9???????? e8???????? }
            // n = 7, score = 400
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8d4de0               | lea                 ecx, [ebp - 0x20]
            //   e8????????           |                     
            //   33f6                 | xor                 esi, esi
            //   e9????????           |                     
            //   e8????????           |                     

        $sequence_2 = { 50 e8???????? 8d4c2424 e8???????? 46 3b770c 7293 }
            // n = 7, score = 400
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d4c2424             | lea                 ecx, [esp + 0x24]
            //   e8????????           |                     
            //   46                   | inc                 esi
            //   3b770c               | cmp                 esi, dword ptr [edi + 0xc]
            //   7293                 | jb                  0xffffff95

        $sequence_3 = { e8???????? 897e34 ff15???????? 5f 5e c20400 55 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   897e34               | mov                 dword ptr [esi + 0x34], edi
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   c20400               | ret                 4
            //   55                   | push                ebp

        $sequence_4 = { 56 57 57 57 53 6801000080 ff15???????? }
            // n = 7, score = 400
            //   56                   | push                esi
            //   57                   | push                edi
            //   57                   | push                edi
            //   57                   | push                edi
            //   53                   | push                ebx
            //   6801000080           | push                0x80000001
            //   ff15????????         |                     

        $sequence_5 = { 85f6 742c 8b5004 2bf2 ff750c 8b08 83c2f8 }
            // n = 7, score = 400
            //   85f6                 | test                esi, esi
            //   742c                 | je                  0x2e
            //   8b5004               | mov                 edx, dword ptr [eax + 4]
            //   2bf2                 | sub                 esi, edx
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   83c2f8               | add                 edx, -8

        $sequence_6 = { 81ce00ffffff 46 8b4df8 8a040e 88040f 47 881c0e }
            // n = 7, score = 400
            //   81ce00ffffff         | or                  esi, 0xffffff00
            //   46                   | inc                 esi
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   8a040e               | mov                 al, byte ptr [esi + ecx]
            //   88040f               | mov                 byte ptr [edi + ecx], al
            //   47                   | inc                 edi
            //   881c0e               | mov                 byte ptr [esi + ecx], bl

        $sequence_7 = { 50 50 8d45f8 50 8d85f0cfffff 50 53 }
            // n = 7, score = 400
            //   50                   | push                eax
            //   50                   | push                eax
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   8d85f0cfffff         | lea                 eax, [ebp - 0x3010]
            //   50                   | push                eax
            //   53                   | push                ebx

        $sequence_8 = { 8b07 5f 8b443004 5e 894304 5b 5d }
            // n = 7, score = 400
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   5f                   | pop                 edi
            //   8b443004             | mov                 eax, dword ptr [eax + esi + 4]
            //   5e                   | pop                 esi
            //   894304               | mov                 dword ptr [ebx + 4], eax
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp

        $sequence_9 = { 83ec18 53 8b5d08 56 57 8bf9 53 }
            // n = 7, score = 400
            //   83ec18               | sub                 esp, 0x18
            //   53                   | push                ebx
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf9                 | mov                 edi, ecx
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 237568
}