rule win_azorult_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.azorult."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.azorult"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d45e8 b102 e8???????? 8d55e8 8d45dc e8???????? 8b45dc }
            // n = 7, score = 1100
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   b102                 | mov                 cl, 2
            //   e8????????           |                     
            //   8d55e8               | lea                 edx, [ebp - 0x18]
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   e8????????           |                     
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]

        $sequence_1 = { 03d8 8d45f8 50 8b45f8 e8???????? }
            // n = 5, score = 1100
            //   03d8                 | add                 ebx, eax
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   e8????????           |                     

        $sequence_2 = { 57 55 bb???????? be???????? bf???????? 807b2800 }
            // n = 6, score = 1100
            //   57                   | push                edi
            //   55                   | push                ebp
            //   bb????????           |                     
            //   be????????           |                     
            //   bf????????           |                     
            //   807b2800             | cmp                 byte ptr [ebx + 0x28], 0

        $sequence_3 = { e8???????? 33c0 55 68???????? 64ff30 648920 8d859cfdffff }
            // n = 7, score = 1100
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   55                   | push                ebp
            //   68????????           |                     
            //   64ff30               | push                dword ptr fs:[eax]
            //   648920               | mov                 dword ptr fs:[eax], esp
            //   8d859cfdffff         | lea                 eax, [ebp - 0x264]

        $sequence_4 = { 2bc3 2bc7 8bf8 85ff 7d02 }
            // n = 5, score = 1100
            //   2bc3                 | sub                 eax, ebx
            //   2bc7                 | sub                 eax, edi
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   7d02                 | jge                 4

        $sequence_5 = { 8d145f 8b442404 e8???????? 8b0424 8bd7 e8???????? }
            // n = 6, score = 1100
            //   8d145f               | lea                 edx, [edi + ebx*2]
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   e8????????           |                     
            //   8b0424               | mov                 eax, dword ptr [esp]
            //   8bd7                 | mov                 edx, edi
            //   e8????????           |                     

        $sequence_6 = { 8d8570fdffff e8???????? 8d8574fdffff ba02000000 }
            // n = 4, score = 1100
            //   8d8570fdffff         | lea                 eax, [ebp - 0x290]
            //   e8????????           |                     
            //   8d8574fdffff         | lea                 eax, [ebp - 0x28c]
            //   ba02000000           | mov                 edx, 2

        $sequence_7 = { 8d8584fdffff ba04000000 e8???????? 8b8584fdffff }
            // n = 4, score = 1100
            //   8d8584fdffff         | lea                 eax, [ebp - 0x27c]
            //   ba04000000           | mov                 edx, 4
            //   e8????????           |                     
            //   8b8584fdffff         | mov                 eax, dword ptr [ebp - 0x27c]

        $sequence_8 = { 7506 ff05???????? 56 e8???????? }
            // n = 4, score = 800
            //   7506                 | jne                 8
            //   ff05????????         |                     
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_9 = { 53 e8???????? 59 56 e8???????? 59 8bc7 }
            // n = 7, score = 800
            //   53                   | push                ebx
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   56                   | push                esi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8bc7                 | mov                 eax, edi

        $sequence_10 = { e8???????? 59 8b45f4 40 }
            // n = 4, score = 500
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   40                   | inc                 eax

        $sequence_11 = { 50 e8???????? 59 8bd8 33c0 }
            // n = 5, score = 500
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8bd8                 | mov                 ebx, eax
            //   33c0                 | xor                 eax, eax

        $sequence_12 = { 85db 7404 8bc3 eb07 }
            // n = 4, score = 500
            //   85db                 | test                ebx, ebx
            //   7404                 | je                  6
            //   8bc3                 | mov                 eax, ebx
            //   eb07                 | jmp                 9

        $sequence_13 = { 011f 59 8bc3 c1e003 01866caf0100 }
            // n = 5, score = 200
            //   011f                 | add                 dword ptr [edi], ebx
            //   59                   | pop                 ecx
            //   8bc3                 | mov                 eax, ebx
            //   c1e003               | shl                 eax, 3
            //   01866caf0100         | add                 dword ptr [esi + 0x1af6c], eax

        $sequence_14 = { 014f18 8b4714 85c0 0f854e010000 }
            // n = 4, score = 200
            //   014f18               | add                 dword ptr [edi + 0x18], ecx
            //   8b4714               | mov                 eax, dword ptr [edi + 0x14]
            //   85c0                 | test                eax, eax
            //   0f854e010000         | jne                 0x154

        $sequence_15 = { 014110 5f 5e 5b }
            // n = 4, score = 200
            //   014110               | add                 dword ptr [ecx + 0x10], eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

    condition:
        7 of them and filesize < 1753088
}