rule win_bangat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bangat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bangat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 59 33c0 8dbdf1fdffff ff7508 f3ab 8365fc00 66ab }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   33c0                 | xor                 eax, eax
            //   8dbdf1fdffff         | lea                 edi, [ebp - 0x20f]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   66ab                 | stosw               word ptr es:[edi], ax

        $sequence_1 = { 50 ff75ec e8???????? 83c40c 83f8ff 74b4 85c0 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   83f8ff               | cmp                 eax, -1
            //   74b4                 | je                  0xffffffb6
            //   85c0                 | test                eax, eax

        $sequence_2 = { ffd7 56 ffd7 59 59 5f 5e }
            // n = 7, score = 100
            //   ffd7                 | call                edi
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_3 = { 7413 3c5f 7405 345e aa ebf2 }
            // n = 6, score = 100
            //   7413                 | je                  0x15
            //   3c5f                 | cmp                 al, 0x5f
            //   7405                 | je                  7
            //   345e                 | xor                 al, 0x5e
            //   aa                   | stosb               byte ptr es:[edi], al
            //   ebf2                 | jmp                 0xfffffff4

        $sequence_4 = { 6800000040 50 e8???????? 83c43c 83f8ff 8945ec 7511 }
            // n = 7, score = 100
            //   6800000040           | push                0x40000000
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c43c               | add                 esp, 0x3c
            //   83f8ff               | cmp                 eax, -1
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   7511                 | jne                 0x13

        $sequence_5 = { 817dfc01040000 7513 68???????? ff75f8 e8???????? 59 }
            // n = 6, score = 100
            //   817dfc01040000       | cmp                 dword ptr [ebp - 4], 0x401
            //   7513                 | jne                 0x15
            //   68????????           |                     
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_6 = { e8???????? 68ad030000 68???????? 6888000000 6a6e e9???????? 8b453c }
            // n = 7, score = 100
            //   e8????????           |                     
            //   68ad030000           | push                0x3ad
            //   68????????           |                     
            //   6888000000           | push                0x88
            //   6a6e                 | push                0x6e
            //   e9????????           |                     
            //   8b453c               | mov                 eax, dword ptr [ebp + 0x3c]

        $sequence_7 = { b800080000 33db 57 66394608 8b3d???????? 7516 833e01 }
            // n = 7, score = 100
            //   b800080000           | mov                 eax, 0x800
            //   33db                 | xor                 ebx, ebx
            //   57                   | push                edi
            //   66394608             | cmp                 word ptr [esi + 8], ax
            //   8b3d????????         |                     
            //   7516                 | jne                 0x18
            //   833e01               | cmp                 dword ptr [esi], 1

        $sequence_8 = { 81eca8030000 53 56 33db 6a40 8d45b0 53 }
            // n = 7, score = 100
            //   81eca8030000         | sub                 esp, 0x3a8
            //   53                   | push                ebx
            //   56                   | push                esi
            //   33db                 | xor                 ebx, ebx
            //   6a40                 | push                0x40
            //   8d45b0               | lea                 eax, [ebp - 0x50]
            //   53                   | push                ebx

        $sequence_9 = { 53 53 6a01 53 8d8588feffff 53 50 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   8d8588feffff         | lea                 eax, [ebp - 0x178]
            //   53                   | push                ebx
            //   50                   | push                eax

    condition:
        7 of them and filesize < 1228800
}