rule win_bankshot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bankshot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bankshot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bf8 8d5101 8a01 41 84c0 75f9 57 }
            // n = 7, score = 300
            //   8bf8                 | lea                 ecx, [esp + 0x58]
            //   8d5101               | push                0x1484
            //   8a01                 | push                edx
            //   41                   | mov                 esi, eax
            //   84c0                 | add                 esp, 0x14
            //   75f9                 | neg                 esi
            //   57                   | sbb                 esi, esi

        $sequence_1 = { 81ec48040000 a1???????? 33c5 8945f8 53 }
            // n = 5, score = 300
            //   81ec48040000         | mov                 ecx, dword ptr [esp + 0x30]
            //   a1????????           |                     
            //   33c5                 | mov                 dword ptr [eax + 4], ebp
            //   8945f8               | mov                 dword ptr [eax + 8], edx
            //   53                   | mov                 dword ptr [eax + 0xc], ecx

        $sequence_2 = { 7ccb 3bca 0f8d20f8ffff 0f1f00 80b40ddc3dffffaa 41 }
            // n = 6, score = 200
            //   7ccb                 | inc                 ecx
            //   3bca                 | test                al, al
            //   0f8d20f8ffff         | jne                 3
            //   0f1f00               | push                edi
            //   80b40ddc3dffffaa     | cmp                 edx, -1
            //   41                   | je                  0x7d

        $sequence_3 = { 83faff 747b 33c9 85d2 7e77 }
            // n = 5, score = 200
            //   83faff               | jbe                 0xfffffff2
            //   747b                 | mov                 ebp, esp
            //   33c9                 | sub                 esp, 0x448
            //   85d2                 | xor                 eax, ebp
            //   7e77                 | mov                 dword ptr [ebp - 8], eax

        $sequence_4 = { 83c40c e8???????? 99 b907000000 }
            // n = 4, score = 200
            //   83c40c               | or                  edx, 0xffffffff
            //   e8????????           |                     
            //   99                   | dec                 eax
            //   b907000000           | lea                 ecx, [0x33e3]

        $sequence_5 = { 57 50 e8???????? 83c40c 6b45e430 8945e0 8d80d0e10110 }
            // n = 7, score = 200
            //   57                   | mov                 eax, dword ptr [ecx*4 + 0x7188c8]
            //   50                   | sub                 esp, 0x448
            //   e8????????           |                     
            //   83c40c               | xor                 eax, ebp
            //   6b45e430             | mov                 dword ptr [ebp - 8], eax
            //   8945e0               | push                ebx
            //   8d80d0e10110         | mov                 ebp, esp

        $sequence_6 = { 8d90c4e10110 5f 668b02 8d5202 668901 8d4902 83ef01 }
            // n = 7, score = 200
            //   8d90c4e10110         | inc                 edx
            //   5f                   | dec                 ebx
            //   668b02               | jne                 0x17
            //   8d5202               | mov                 eax, dword ptr [ebp - 4]
            //   668901               | cmp                 dword ptr [eax + 0x48], 0x1001e4b8
            //   8d4902               | mov                 eax, dword ptr [eax + 0x48]
            //   83ef01               | lock xadd           dword ptr [eax], ebx

        $sequence_7 = { 8bb5a838ffff 8d8db438ffff 68???????? 894608 c70610000000 c7460400000000 }
            // n = 6, score = 200
            //   8bb5a838ffff         | xor                 ecx, ecx
            //   8d8db438ffff         | test                edx, edx
            //   68????????           |                     
            //   894608               | jle                 0x7f
            //   c70610000000         | call                edi
            //   c7460400000000       | mov                 dword ptr [ebp - 0xc540], 0

        $sequence_8 = { 8945e0 8d80d0e10110 8945e4 803800 8bc8 7435 8a4101 }
            // n = 7, score = 200
            //   8945e0               | mov                 ecx, edi
            //   8d80d0e10110         | mov                 eax, edi
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   803800               | cmp                 dword ptr [eax + 0x1001e1c0], ebx
            //   8bc8                 | je                  0xf0
            //   7435                 | inc                 ecx
            //   8a4101               | lea                 edx, [eax + 0x1001e1c4]

        $sequence_9 = { ffd7 c785c03affff00000000 8b85bc3affff 85c0 }
            // n = 4, score = 200
            //   ffd7                 | push                ebx
            //   c785c03affff00000000     | push    ebp
            //   8b85bc3affff         | mov                 ebp, esp
            //   85c0                 | sub                 esp, 0x448

        $sequence_10 = { 85db 7507 c746340c7b0110 57 ff7634 }
            // n = 5, score = 200
            //   85db                 | add                 esp, 0xc
            //   7507                 | imul                eax, dword ptr [ebp - 0x1c], 0x30
            //   c746340c7b0110       | mov                 dword ptr [ebp - 0x20], eax
            //   57                   | lea                 eax, [eax + 0x1001e1d0]
            //   ff7634               | cmp                 dword ptr [eax + 0x48], 0x1001e4b8

        $sequence_11 = { e8???????? 83c404 89861c020000 8b45e0 8d4e0c 6a06 8d90c4e10110 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c404               | mov                 dword ptr [eax + 0x48], 0x1001e4b8
            //   89861c020000         | mov                 eax, dword ptr [ebp + 8]
            //   8b45e0               | mov                 word ptr [eax + 0x6c], cx
            //   8d4e0c               | mov                 eax, dword ptr [ebp + 8]
            //   6a06                 | lock xadd           dword ptr [eax], ebx
            //   8d90c4e10110         | dec                 ebx

        $sequence_12 = { 7515 8b45fc 817848b8e40110 7409 ff7048 e8???????? 59 }
            // n = 7, score = 200
            //   7515                 | mov                 edi, eax
            //   8b45fc               | lea                 edx, [ecx + 1]
            //   817848b8e40110       | mov                 al, byte ptr [ecx]
            //   7409                 | inc                 ecx
            //   ff7048               | test                al, al
            //   e8????????           |                     
            //   59                   | jne                 3

        $sequence_13 = { c7832005000000008000 eb4e b9???????? 8d85d4fdffff }
            // n = 4, score = 200
            //   c7832005000000008000     | xor    eax, ebp
            //   eb4e                 | mov                 dword ptr [ebp - 8], eax
            //   b9????????           |                     
            //   8d85d4fdffff         | push                ebx

        $sequence_14 = { e9???????? 57 33ff 8bcf 8bc7 894de4 3998c0e10110 }
            // n = 7, score = 200
            //   e9????????           |                     
            //   57                   | jne                 0x17
            //   33ff                 | mov                 eax, dword ptr [ebp - 4]
            //   8bcf                 | cmp                 dword ptr [eax + 0x48], 0x1001e4b8
            //   8bc7                 | je                  0x15
            //   894de4               | push                dword ptr [eax + 0x48]
            //   3998c0e10110         | pop                 ecx

        $sequence_15 = { 8b4508 c700???????? 8b4508 898850030000 8b4508 59 c74048b8e40110 }
            // n = 7, score = 200
            //   8b4508               | push                6
            //   c700????????         |                     
            //   8b4508               | lea                 edx, [eax + 0x1001e1c4]
            //   898850030000         | pop                 edi
            //   8b4508               | mov                 ax, word ptr [edx]
            //   59                   | lea                 edx, [edx + 2]
            //   c74048b8e40110       | mov                 word ptr [ecx], ax

        $sequence_16 = { 0f10440b10 0f28ca 660fefc8 0f114c0b10 83c120 3bce 7cd9 }
            // n = 7, score = 200
            //   0f10440b10           | sub                 esp, 0x448
            //   0f28ca               | xor                 eax, ebp
            //   660fefc8             | mov                 dword ptr [ebp - 8], eax
            //   0f114c0b10           | push                ebx
            //   83c120               | mov                 edi, eax
            //   3bce                 | lea                 edx, [ecx + 1]
            //   7cd9                 | mov                 al, byte ptr [ecx]

        $sequence_17 = { 33c0 8996a0af0600 668b04dd66734100 83fb02 898694af0600 }
            // n = 5, score = 100
            //   33c0                 | dec                 eax
            //   8996a0af0600         | lea                 edx, [0xe75e]
            //   668b04dd66734100     | dec                 eax
            //   83fb02               | lea                 ecx, [esp + 0x20]
            //   898694af0600         | add                 esp, 0xc

        $sequence_18 = { 83c101 894df8 837df803 0f83d2000000 6a04 }
            // n = 5, score = 100
            //   83c101               | cdq                 
            //   894df8               | mov                 ecx, 7
            //   837df803             | idiv                ecx
            //   0f83d2000000         | add                 esp, 0xc
            //   6a04                 | cdq                 

        $sequence_19 = { eb3a 81c694010000 740e f30f7e06 660fd685ccfeffff eb24 }
            // n = 6, score = 100
            //   eb3a                 | mov                 dword ptr [ebp - 8], eax
            //   81c694010000         | push                ebx
            //   740e                 | mov                 ebp, esp
            //   f30f7e06             | sub                 esp, 0x448
            //   660fd685ccfeffff     | xor                 eax, ebp
            //   eb24                 | mov                 dword ptr [ebp - 8], eax

        $sequence_20 = { 7506 8d4707 50 eb01 57 8d7e10 }
            // n = 6, score = 100
            //   7506                 | push                ebx
            //   8d4707               | cmp                 edx, 0x3e7
            //   50                   | ja                  0xa
            //   eb01                 | add                 edx, 0x3e8
            //   57                   | mov                 dword ptr [eax], edx
            //   8d7e10               | mov                 ecx, dword ptr [ebx]

        $sequence_21 = { 894df8 837dd8ff 7464 6a00 }
            // n = 4, score = 100
            //   894df8               | push                edi
            //   837dd8ff             | lea                 edi, [esi + 0x10]
            //   7464                 | push                edi
            //   6a00                 | mov                 dword ptr [ebp - 0x434], eax

        $sequence_22 = { ff15???????? 4885c0 0f8482000000 48ffc3 4a89042f 488d3cdd00000000 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   4885c0               | lea                 edx, [0xea56]
            //   0f8482000000         | dec                 eax
            //   48ffc3               | lea                 ecx, [esp + 0x20]
            //   4a89042f             | cmp                 byte ptr [esp + 0x20], 0
            //   488d3cdd00000000     | dec                 eax

        $sequence_23 = { 41 890d???????? 33c0 8b4df4 64890d00000000 }
            // n = 5, score = 100
            //   41                   | push                0
            //   890d????????         |                     
            //   33c0                 | mov                 ebp, esp
            //   8b4df4               | mov                 eax, dword ptr [ebp + 8]
            //   64890d00000000       | push                edi

        $sequence_24 = { 44897c2420 ff15???????? 488bf8 83caff }
            // n = 4, score = 100
            //   44897c2420           | dec                 eax
            //   ff15????????         |                     
            //   488bf8               | lea                 edi, [ebx*8]
            //   83caff               | inc                 esp

        $sequence_25 = { 0f84b6000000 488d3ded3e0000 498bf0 b903000000 f3a6 }
            // n = 5, score = 100
            //   0f84b6000000         | inc                 edi
            //   488d3ded3e0000       | dec                 eax
            //   498bf0               | add                 ebx, 0x28
            //   b903000000           | inc                 esp
            //   f3a6                 | mov                 dword ptr [esp + 0x20], edi

        $sequence_26 = { ba7a341200 488bcf 8905???????? e8???????? 488d0d7d2b0000 }
            // n = 5, score = 100
            //   ba7a341200           | add                 edx, esp
            //   488bcf               | dec                 eax
            //   8905????????         |                     
            //   e8????????           |                     
            //   488d0d7d2b0000       | mov                 eax, dword ptr [esi + 0x1c]

        $sequence_27 = { 23f0 68???????? 89b564f2ffff ffd7 68???????? 50 ffd3 }
            // n = 7, score = 100
            //   23f0                 | push                ebx
            //   68????????           |                     
            //   89b564f2ffff         | push                ebp
            //   ffd7                 | mov                 ebp, esp
            //   68????????           |                     
            //   50                   | sub                 esp, 0x448
            //   ffd3                 | xor                 eax, ebp

        $sequence_28 = { 81fae7030000 7708 81c2e8030000 8910 8b0b 6a00 68e6210000 }
            // n = 7, score = 100
            //   81fae7030000         | mov                 ecx, ebx
            //   7708                 | mov                 edi, eax
            //   81c2e8030000         | lea                 edx, [ecx + 1]
            //   8910                 | mov                 al, byte ptr [ecx]
            //   8b0b                 | inc                 ecx
            //   6a00                 | test                al, al
            //   68e6210000           | jne                 3

        $sequence_29 = { c705????????01000000 c705????????05000000 66c705????????3c00 c705????????04000000 e8???????? 68???????? }
            // n = 6, score = 100
            //   c705????????01000000     |     
            //   c705????????05000000     |     
            //   66c705????????3c00     |     
            //   c705????????04000000     |     
            //   e8????????           |                     
            //   68????????           |                     

        $sequence_30 = { 0f859b010000 c745e068410110 8b4508 8bcf }
            // n = 4, score = 100
            //   0f859b010000         | push                edi
            //   c745e068410110       | sub                 esp, 0x448
            //   8b4508               | xor                 eax, ebp
            //   8bcf                 | mov                 dword ptr [ebp - 8], eax

        $sequence_31 = { 85c0 7543 8b542454 8d4c2458 6884140000 }
            // n = 5, score = 100
            //   85c0                 | cdq                 
            //   7543                 | mov                 ecx, 7
            //   8b542454             | add                 esp, 0xc
            //   8d4c2458             | cdq                 
            //   6884140000           | mov                 ecx, 7

        $sequence_32 = { ff15???????? 68???????? 57 8985ccfbffff ff15???????? }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   68????????           |                     
            //   57                   | push                0
            //   8985ccfbffff         | push                0x21e6
            //   ff15????????         |                     

        $sequence_33 = { 8bec 8b4508 57 8d3c85108c7100 8b0f 85c9 }
            // n = 6, score = 100
            //   8bec                 | mov                 ecx, dword ptr [eax*4 + 0x10017fc8]
            //   8b4508               | mov                 eax, dword ptr [ebp - 0x18]
            //   57                   | test                byte ptr [ecx + eax + 0x28], 0x80
            //   8d3c85108c7100       | je                  0x50
            //   8b0f                 | movsx               eax, bl
            //   85c9                 | add                 esp, 0xc

        $sequence_34 = { 52 e8???????? 8bf0 83c414 f7de 1bf6 }
            // n = 6, score = 100
            //   52                   | add                 esp, 0xc
            //   e8????????           |                     
            //   8bf0                 | cdq                 
            //   83c414               | mov                 ecx, 7
            //   f7de                 | idiv                ecx
            //   1bf6                 | add                 esp, 0xc

        $sequence_35 = { 837d0c00 7455 8b4d0c 51 ff15???????? }
            // n = 5, score = 100
            //   837d0c00             | mov                 ecx, 7
            //   7455                 | add                 esp, 0xc
            //   8b4d0c               | cdq                 
            //   51                   | mov                 ecx, 7
            //   ff15????????         |                     

        $sequence_36 = { ff15???????? 488d1556ea0000 488d4c2420 488905???????? ff15???????? 807c242000 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   488d1556ea0000       | test                eax, eax
            //   488d4c2420           | je                  0xbb
            //   488905????????       |                     
            //   ff15????????         |                     
            //   807c242000           | dec                 eax

        $sequence_37 = { 448bc1 4a8d4c0d00 4903d4 e8???????? 488b461c ffc7 4883c328 }
            // n = 7, score = 100
            //   448bc1               | test                eax, eax
            //   4a8d4c0d00           | je                  0x88
            //   4903d4               | dec                 eax
            //   e8????????           |                     
            //   488b461c             | inc                 ebx
            //   ffc7                 | dec                 edx
            //   4883c328             | mov                 dword ptr [edi + ebp], eax

        $sequence_38 = { 52 50 e8???????? 6a02 8d8c24b0080000 6a00 8d54244c }
            // n = 7, score = 100
            //   52                   | push                edi
            //   50                   | push                0x1484
            //   e8????????           |                     
            //   6a02                 | push                0x40
            //   8d8c24b0080000       | mov                 ebx, eax
            //   6a00                 | xor                 eax, eax
            //   8d54244c             | mov                 dword ptr [esi + 0x6afa0], edx

        $sequence_39 = { 3bd1 7f1e 6b0d????????3c 030d???????? }
            // n = 4, score = 100
            //   3bd1                 | add                 esp, 0xc
            //   7f1e                 | cdq                 
            //   6b0d????????3c       |                     
            //   030d????????         |                     

        $sequence_40 = { 56 57 6884140000 6a40 ff15???????? 8bd8 }
            // n = 6, score = 100
            //   56                   | lea                 edi, [0x3eed]
            //   57                   | dec                 ecx
            //   6884140000           | mov                 esi, eax
            //   6a40                 | mov                 ecx, 3
            //   ff15????????         |                     
            //   8bd8                 | repe cmpsb          byte ptr [esi], byte ptr es:[edi]

        $sequence_41 = { e8???????? 488d0de3330000 e8???????? 488d0d87990000 e8???????? 84c0 0f85b6000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d0de3330000       | mov                 eax, ecx
            //   e8????????           |                     
            //   488d0d87990000       | dec                 edx
            //   e8????????           |                     
            //   84c0                 | lea                 ecx, [ebp + ecx]
            //   0f85b6000000         | dec                 ecx

        $sequence_42 = { 8b4c2430 896804 895008 89480c e8???????? }
            // n = 5, score = 100
            //   8b4c2430             | cdq                 
            //   896804               | mov                 ecx, 7
            //   895008               | idiv                ecx
            //   89480c               | push                esi
            //   e8????????           |                     

        $sequence_43 = { 50 e8???????? 83c404 898568f8ffff 8d8df4fdffff 51 }
            // n = 6, score = 100
            //   50                   | mov                 ecx, 7
            //   e8????????           |                     
            //   83c404               | idiv                ecx
            //   898568f8ffff         | mov                 dword ptr [ebp - 8], ecx
            //   8d8df4fdffff         | cmp                 dword ptr [ebp - 0x28], -1
            //   51                   | je                  0x6a

        $sequence_44 = { ff15???????? 488bf8 4885c0 0f84b5000000 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   488bf8               | dec                 eax
            //   4885c0               | mov                 edi, eax
            //   0f84b5000000         | dec                 eax

    condition:
        7 of them and filesize < 860160
}