rule win_banpolmex_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.banpolmex."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.banpolmex"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d15db730200 4881c128050000 e8???????? 85c0 0f8564010000 8d5019 }
            // n = 6, score = 100
            //   488d15db730200       | or                  ecx, ebp
            //   4881c128050000       | inc                 esp
            //   e8????????           |                     
            //   85c0                 | xor                 ecx, eax
            //   0f8564010000         | inc                 ecx
            //   8d5019               | and                 ecx, ebp

        $sequence_1 = { 48896c2420 e8???????? 488d8c2490040000 ff15???????? 85c0 7508 ff15???????? }
            // n = 7, score = 100
            //   48896c2420           | dec                 ecx
            //   e8????????           |                     
            //   488d8c2490040000     | mov                 ecx, esi
            //   ff15????????         |                     
            //   85c0                 | inc                 ecx
            //   7508                 | mov                 dword ptr [edi + 0x2d4], 1
            //   ff15????????         |                     

        $sequence_2 = { 488d4c2430 41b001 e8???????? 85c0 7566 8b442420 3c7f }
            // n = 7, score = 100
            //   488d4c2430           | inc                 ecx
            //   41b001               | and                 cl, 0x10
            //   e8????????           |                     
            //   85c0                 | dec                 esp
            //   7566                 | lea                 eax, [0x7ca85]
            //   8b442420             | mov                 edx, edi
            //   3c7f                 | dec                 eax

        $sequence_3 = { 4c8d0d45870300 4885c0 4d8bd9 4d8bd1 4c0f45d8 488b442478 498bf9 }
            // n = 7, score = 100
            //   4c8d0d45870300       | lea                 edx, [0x7d19a]
            //   4885c0               | dec                 eax
            //   4d8bd9               | lea                 ecx, [esp + 0x30]
            //   4d8bd1               | inc                 esp
            //   4c0f45d8             | mov                 eax, esi
            //   488b442478           | dec                 eax
            //   498bf9               | lea                 edx, [ebp - 0x49]

        $sequence_4 = { 7525 b9d0000000 e8???????? 48898690030000 4885c0 745e 488b16 }
            // n = 7, score = 100
            //   7525                 | inc                 ecx
            //   b9d0000000           | movzx               eax, byte ptr [ecx + eax + 0x1d164]
            //   e8????????           |                     
            //   48898690030000       | inc                 ebp
            //   4885c0               | mov                 eax, dword ptr [ecx + eax*4 + 0x1d150]
            //   745e                 | dec                 ebp
            //   488b16               | add                 eax, ecx

        $sequence_5 = { 488d15587ffeff bf00020000 8b8c82c8820100 4803ca ffe1 80bb7403000007 731f }
            // n = 7, score = 100
            //   488d15587ffeff       | dec                 eax
            //   bf00020000           | mov                 esi, dword ptr [esp + 0x60]
            //   8b8c82c8820100       | test                ebp, ebp
            //   4803ca               | dec                 eax
            //   ffe1                 | lea                 ecx, [0x1bc56]
            //   80bb7403000007       | dec                 esp
            //   731f                 | cmovne              esp, eax

        $sequence_6 = { 894c2420 488d154df70100 488bcb e8???????? e9???????? c74424385d000000 89542430 }
            // n = 7, score = 100
            //   894c2420             | inc                 ecx
            //   488d154df70100       | movzx               eax, byte ptr [edi + eax*4 + 0x1000]
            //   488bcb               | inc                 esp
            //   e8????????           |                     
            //   e9????????           |                     
            //   c74424385d000000     | xor                 edx, eax
            //   89542430             | inc                 eax

        $sequence_7 = { 7459 398360040000 7551 488d0530cf0200 483987f8020000 7522 488d05a0cf0200 }
            // n = 7, score = 100
            //   7459                 | dec                 eax
            //   398360040000         | mov                 ecx, eax
            //   7551                 | test                eax, eax
            //   488d0530cf0200       | jne                 0x31b
            //   483987f8020000       | je                  0x445
            //   7522                 | dec                 ecx
            //   488d05a0cf0200       | je                  0x281

        $sequence_8 = { 7517 448d4004 33d2 488bcb ff15???????? 85c0 0f84d5fdffff }
            // n = 7, score = 100
            //   7517                 | js                  0x608
            //   448d4004             | jne                 0xafc
            //   33d2                 | inc                 ebp
            //   488bcb               | test                ebp, ebp
            //   ff15????????         |                     
            //   85c0                 | dec                 eax
            //   0f84d5fdffff         | lea                 ecx, [0x218ef]

        $sequence_9 = { 89442420 e8???????? 8bd8 33ff 85db 740f 488d15f8f40100 }
            // n = 7, score = 100
            //   89442420             | xor                 edx, dword ptr [esi + 8]
            //   e8????????           |                     
            //   8bd8                 | inc                 ecx
            //   33ff                 | movzx               eax, al
            //   85db                 | inc                 ecx
            //   740f                 | mov                 ecx, dword ptr [edi + eax*4 + 0x1000]
            //   488d15f8f40100       | inc                 ecx

    condition:
        7 of them and filesize < 1555456
}