rule win_beatdrop_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.beatdrop."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.beatdrop"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 31fa 895110 3351f4 895114 }
            // n = 4, score = 400
            //   31fa                 | movzx               edx, dl
            //   895110               | inc                 ebx
            //   3351f4               | xor                 eax, dword ptr [esp + edx*4 + 0x400]
            //   895114               | inc                 esp

        $sequence_1 = { ff15???????? 488b03 8a10 80fa02 743f }
            // n = 5, score = 400
            //   ff15????????         |                     
            //   488b03               | lea                 edx, [0x11b18]
            //   8a10                 | dec                 eax
            //   80fa02               | lea                 ecx, [0x13211]
            //   743f                 | dec                 eax

        $sequence_2 = { 4883e810 4883c428 5b 5e 5f 5d }
            // n = 6, score = 400
            //   4883e810             | lea                 edx, [0xd1a1]
            //   4883c428             | dec                 eax
            //   5b                   | lea                 ecx, [0xd097]
            //   5e                   | dec                 ecx
            //   5f                   | mov                 esp, eax
            //   5d                   | dec                 ebp

        $sequence_3 = { 4154 4883ec48 4c8d6c2430 4989cc 4c89e9 e8???????? 4c89ea }
            // n = 7, score = 400
            //   4154                 | dec                 eax
            //   4883ec48             | lea                 edx, [0x1b6d1]
            //   4c8d6c2430           | dec                 eax
            //   4989cc               | mov                 ecx, eax
            //   4c89e9               | call                ebx
            //   e8????????           |                     
            //   4c89ea               | dec                 eax

        $sequence_4 = { 400fb6ff 41339cbd00040000 0fb6fd 4489d9 41339cbd00080000 413394b5000c0000 c1e810 }
            // n = 7, score = 400
            //   400fb6ff             | dec                 esp
            //   41339cbd00040000     | mov                 ecx, ebp
            //   0fb6fd               | dec                 eax
            //   4489d9               | lea                 ecx, [0x10a5b]
            //   41339cbd00080000     | dec                 ecx
            //   413394b5000c0000     | mov                 ecx, eax
            //   c1e810               | mov                 ecx, 2

        $sequence_5 = { 4889442458 e8???????? eb0a 4889f1 e8???????? eb8d }
            // n = 6, score = 400
            //   4889442458           | dec                 ecx
            //   e8????????           |                     
            //   eb0a                 | mov                 eax, edx
            //   4889f1               | dec                 ecx
            //   e8????????           |                     
            //   eb8d                 | mov                 ecx, ebx

        $sequence_6 = { 498344241010 eb11 498d4c2408 e8???????? eb05 49ff442418 }
            // n = 6, score = 400
            //   498344241010         | mov                 ecx, dword ptr [esp + 0x58]
            //   eb11                 | xor                 edx, edx
            //   498d4c2408           | dec                 eax
            //   e8????????           |                     
            //   eb05                 | mov                 ecx, eax
            //   49ff442418           | dec                 eax

        $sequence_7 = { c3 4889c8 4c8d998c030000 4889ca 0f1f00 }
            // n = 5, score = 400
            //   c3                   | lea                 ecx, [0x1ef83]
            //   4889c8               | mov                 dword ptr [eax], 0xffff8000
            //   4c8d998c030000       | dec                 eax
            //   4889ca               | mov                 eax, dword ptr [esp + 0x110]
            //   0f1f00               | dec                 eax

        $sequence_8 = { 89aef8000000 44899efc000000 478b84bc00080000 898e00010000 4181e0000000ff }
            // n = 5, score = 400
            //   89aef8000000         | dec                 eax
            //   44899efc000000       | mov                 ecx, esi
            //   478b84bc00080000     | dec                 esp
            //   898e00010000         | mov                 ecx, edi
            //   4181e0000000ff       | dec                 eax

        $sequence_9 = { 4c89e9 e8???????? 4c89e0 4883c450 5b }
            // n = 5, score = 400
            //   4c89e9               | inc                 ebp
            //   e8????????           |                     
            //   4c89e0               | xor                 esi, dword ptr [ebp + edx*4 + 0x400]
            //   4883c450             | inc                 esp
            //   5b                   | mov                 edx, ebx

    condition:
        7 of them and filesize < 584704
}