rule win_bedep_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bedep."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bedep"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4608 50 ff75e8 90 e8???????? 84c0 7406 }
            // n = 7, score = 100
            //   8d4608               | lea                 eax, [esi + 8]
            //   50                   | push                eax
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   90                   | nop                 
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7406                 | je                  8

        $sequence_1 = { 8d4608 50 e8???????? 68???????? 8d4610 50 e8???????? }
            // n = 7, score = 100
            //   8d4608               | lea                 eax, [esi + 8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   68????????           |                     
            //   8d4610               | lea                 eax, [esi + 0x10]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_2 = { 7d0f 8b11 8910 8b4904 894804 e9???????? 395de8 }
            // n = 7, score = 100
            //   7d0f                 | jge                 0x11
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8910                 | mov                 dword ptr [eax], edx
            //   8b4904               | mov                 ecx, dword ptr [ecx + 4]
            //   894804               | mov                 dword ptr [eax + 4], ecx
            //   e9????????           |                     
            //   395de8               | cmp                 dword ptr [ebp - 0x18], ebx

        $sequence_3 = { 8930 897704 eb6c 8b5610 8b4710 83c23f 83e2c0 }
            // n = 7, score = 100
            //   8930                 | mov                 dword ptr [eax], esi
            //   897704               | mov                 dword ptr [edi + 4], esi
            //   eb6c                 | jmp                 0x6e
            //   8b5610               | mov                 edx, dword ptr [esi + 0x10]
            //   8b4710               | mov                 eax, dword ptr [edi + 0x10]
            //   83c23f               | add                 edx, 0x3f
            //   83e2c0               | and                 edx, 0xffffffc0

        $sequence_4 = { ff9424d8010000 8bd8 85db 7504 6af1 ebda 6a0e }
            // n = 7, score = 100
            //   ff9424d8010000       | call                dword ptr [esp + 0x1d8]
            //   8bd8                 | mov                 ebx, eax
            //   85db                 | test                ebx, ebx
            //   7504                 | jne                 6
            //   6af1                 | push                -0xf
            //   ebda                 | jmp                 0xffffffdc
            //   6a0e                 | push                0xe

        $sequence_5 = { ff5108 8b45fc 5b c9 c20c00 6898000000 6a00 }
            // n = 7, score = 100
            //   ff5108               | call                dword ptr [ecx + 8]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   5b                   | pop                 ebx
            //   c9                   | leave               
            //   c20c00               | ret                 0xc
            //   6898000000           | push                0x98
            //   6a00                 | push                0

        $sequence_6 = { 7605 8bd8 895df0 33d2 8d46ff f7f3 }
            // n = 6, score = 100
            //   7605                 | jbe                 7
            //   8bd8                 | mov                 ebx, eax
            //   895df0               | mov                 dword ptr [ebp - 0x10], ebx
            //   33d2                 | xor                 edx, edx
            //   8d46ff               | lea                 eax, [esi - 1]
            //   f7f3                 | div                 ebx

        $sequence_7 = { ff751c ff750c ff7508 68???????? e8???????? 5d c22800 }
            // n = 7, score = 100
            //   ff751c               | push                dword ptr [ebp + 0x1c]
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   68????????           |                     
            //   e8????????           |                     
            //   5d                   | pop                 ebp
            //   c22800               | ret                 0x28

        $sequence_8 = { 5e 5b c9 c21800 55 8bec 81ec80000000 }
            // n = 7, score = 100
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c9                   | leave               
            //   c21800               | ret                 0x18
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec80000000         | sub                 esp, 0x80

        $sequence_9 = { 51 56 8b35???????? 85f6 0f8d9b000000 6a05 b004 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   56                   | push                esi
            //   8b35????????         |                     
            //   85f6                 | test                esi, esi
            //   0f8d9b000000         | jge                 0xa1
            //   6a05                 | push                5
            //   b004                 | mov                 al, 4

    condition:
        7 of them and filesize < 557056
}