rule win_bezigate_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bezigate"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3b4510 7407 b014 e8???????? 8d45f0 e8???????? }
            // n = 6, score = 100
            //   3b4510               | cmp                 eax, dword ptr [ebp + 0x10]
            //   7407                 | je                  9
            //   b014                 | mov                 al, 0x14
            //   e8????????           |                     
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   e8????????           |                     

        $sequence_1 = { 33c0 8a03 50 e8???????? 663bf0 7306 }
            // n = 6, score = 100
            //   33c0                 | xor                 eax, eax
            //   8a03                 | mov                 al, byte ptr [ebx]
            //   50                   | push                eax
            //   e8????????           |                     
            //   663bf0               | cmp                 si, ax
            //   7306                 | jae                 8

        $sequence_2 = { e9???????? ff75f4 ff75f0 b201 a1???????? e8???????? 8b55f8 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   b201                 | mov                 dl, 1
            //   a1????????           |                     
            //   e8????????           |                     
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]

        $sequence_3 = { 8b45ec 8b08 ff5108 8b45fc }
            // n = 4, score = 100
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff5108               | call                dword ptr [ecx + 8]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_4 = { 8bd8 8bd6 8bc3 e8???????? 33c0 8a06 83f81b }
            // n = 7, score = 100
            //   8bd8                 | mov                 ebx, eax
            //   8bd6                 | mov                 edx, esi
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   8a06                 | mov                 al, byte ptr [esi]
            //   83f81b               | cmp                 eax, 0x1b

        $sequence_5 = { 83bf1002000000 7414 8bc7 e8???????? 3bf0 7509 33d2 }
            // n = 7, score = 100
            //   83bf1002000000       | cmp                 dword ptr [edi + 0x210], 0
            //   7414                 | je                  0x16
            //   8bc7                 | mov                 eax, edi
            //   e8????????           |                     
            //   3bf0                 | cmp                 esi, eax
            //   7509                 | jne                 0xb
            //   33d2                 | xor                 edx, edx

        $sequence_6 = { 8b55f8 8b45fc 8b4df4 e8???????? 807df307 755f 80fb07 }
            // n = 7, score = 100
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   e8????????           |                     
            //   807df307             | cmp                 byte ptr [ebp - 0xd], 7
            //   755f                 | jne                 0x61
            //   80fb07               | cmp                 bl, 7

        $sequence_7 = { e8???????? e8???????? 33c0 8ac3 668b044504654700 6683f80a }
            // n = 6, score = 100
            //   e8????????           |                     
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   8ac3                 | mov                 al, bl
            //   668b044504654700     | mov                 ax, word ptr [eax*2 + 0x476504]
            //   6683f80a             | cmp                 ax, 0xa

        $sequence_8 = { 56 e8???????? eb1e 8bd4 8bc3 e8???????? 84c0 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   e8????????           |                     
            //   eb1e                 | jmp                 0x20
            //   8bd4                 | mov                 edx, esp
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     
            //   84c0                 | test                al, al

        $sequence_9 = { 0f94c0 5e 5b c3 6683f801 7509 66833e01 }
            // n = 7, score = 100
            //   0f94c0               | sete                al
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   6683f801             | cmp                 ax, 1
            //   7509                 | jne                 0xb
            //   66833e01             | cmp                 word ptr [esi], 1

    condition:
        7 of them and filesize < 1875968
}