rule win_bhunt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bhunt."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bhunt"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4510 50 8d75e0 895d10 e8???????? 8b4508 40 }
            // n = 7, score = 100
            //   8d4510               | lea                 eax, [ebp + 0x10]
            //   50                   | push                eax
            //   8d75e0               | lea                 esi, [ebp - 0x20]
            //   895d10               | mov                 dword ptr [ebp + 0x10], ebx
            //   e8????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   40                   | inc                 eax

        $sequence_1 = { 81c19a343e57 f5 c1c903 3be2 f7c43b003f6a 85cd 0fc9 }
            // n = 7, score = 100
            //   81c19a343e57         | add                 ecx, 0x573e349a
            //   f5                   | cmc                 
            //   c1c903               | ror                 ecx, 3
            //   3be2                 | cmp                 esp, edx
            //   f7c43b003f6a         | test                esp, 0x6a3f003b
            //   85cd                 | test                ebp, ecx
            //   0fc9                 | bswap               ecx

        $sequence_2 = { f8 33c3 48 c1c003 80fb62 2d89703a21 f7c6fc739c51 }
            // n = 7, score = 100
            //   f8                   | clc                 
            //   33c3                 | xor                 eax, ebx
            //   48                   | dec                 eax
            //   c1c003               | rol                 eax, 3
            //   80fb62               | cmp                 bl, 0x62
            //   2d89703a21           | sub                 eax, 0x213a7089
            //   f7c6fc739c51         | test                esi, 0x519c73fc

        $sequence_3 = { 0bee 236c2414 23fe 0bef 036c2450 895c241c }
            // n = 6, score = 100
            //   0bee                 | or                  ebp, esi
            //   236c2414             | and                 ebp, dword ptr [esp + 0x14]
            //   23fe                 | and                 edi, esi
            //   0bef                 | or                  ebp, edi
            //   036c2450             | add                 ebp, dword ptr [esp + 0x50]
            //   895c241c             | mov                 dword ptr [esp + 0x1c], ebx

        $sequence_4 = { 8b5604 f9 f7d1 f5 f7c727065338 6685eb f7d2 }
            // n = 7, score = 100
            //   8b5604               | mov                 edx, dword ptr [esi + 4]
            //   f9                   | stc                 
            //   f7d1                 | not                 ecx
            //   f5                   | cmc                 
            //   f7c727065338         | test                edi, 0x38530627
            //   6685eb               | test                bx, bp
            //   f7d2                 | not                 edx

        $sequence_5 = { 8bc1 c1f805 8bf1 8d3c8500e04900 8b07 83e61f c1e606 }
            // n = 7, score = 100
            //   8bc1                 | mov                 eax, ecx
            //   c1f805               | sar                 eax, 5
            //   8bf1                 | mov                 esi, ecx
            //   8d3c8500e04900       | lea                 edi, [eax*4 + 0x49e000]
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   83e61f               | and                 esi, 0x1f
            //   c1e606               | shl                 esi, 6

        $sequence_6 = { 8bd3 0fbcc2 c1e202 80eca7 8bc5 f5 663bd7 }
            // n = 7, score = 100
            //   8bd3                 | mov                 edx, ebx
            //   0fbcc2               | bsf                 eax, edx
            //   c1e202               | shl                 edx, 2
            //   80eca7               | sub                 ah, 0xa7
            //   8bc5                 | mov                 eax, ebp
            //   f5                   | cmc                 
            //   663bd7               | cmp                 dx, di

        $sequence_7 = { ff7304 8b45fc ff30 8d7be4 e8???????? 59 59 }
            // n = 7, score = 100
            //   ff7304               | push                dword ptr [ebx + 4]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   ff30                 | push                dword ptr [eax]
            //   8d7be4               | lea                 edi, [ebx - 0x1c]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx

        $sequence_8 = { ff5070 8bb7a4060000 68???????? e8???????? 83f8ff 7543 391d???????? }
            // n = 7, score = 100
            //   ff5070               | call                dword ptr [eax + 0x70]
            //   8bb7a4060000         | mov                 esi, dword ptr [edi + 0x6a4]
            //   68????????           |                     
            //   e8????????           |                     
            //   83f8ff               | cmp                 eax, -1
            //   7543                 | jne                 0x45
            //   391d????????         |                     

        $sequence_9 = { c1e21c 33db c1ef04 0bd8 8b04cd68fa4400 0bd7 8bfa }
            // n = 7, score = 100
            //   c1e21c               | shl                 edx, 0x1c
            //   33db                 | xor                 ebx, ebx
            //   c1ef04               | shr                 edi, 4
            //   0bd8                 | or                  ebx, eax
            //   8b04cd68fa4400       | mov                 eax, dword ptr [ecx*8 + 0x44fa68]
            //   0bd7                 | or                  edx, edi
            //   8bfa                 | mov                 edi, edx

    condition:
        7 of them and filesize < 19161088
}