rule win_bitsloth_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bitsloth."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bitsloth"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c40c 68???????? e8???????? 83c404 c645fc00 8d8d64f0ffff e8???????? }
            // n = 7, score = 100
            //   83c40c               | add                 esp, 0xc
            //   68????????           |                     
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c645fc00             | mov                 byte ptr [ebp - 4], 0
            //   8d8d64f0ffff         | lea                 ecx, [ebp - 0xf9c]
            //   e8????????           |                     

        $sequence_1 = { c78564f9feff00000000 eb0b 1bc9 83c901 898d64f9feff }
            // n = 5, score = 100
            //   c78564f9feff00000000     | mov    dword ptr [ebp - 0x1069c], 0
            //   eb0b                 | jmp                 0xd
            //   1bc9                 | sbb                 ecx, ecx
            //   83c901               | or                  ecx, 1
            //   898d64f9feff         | mov                 dword ptr [ebp - 0x1069c], ecx

        $sequence_2 = { 83c408 8d8de0faffff 51 8d95bcf1ffff 52 68c50b0000 8b4508 }
            // n = 7, score = 100
            //   83c408               | add                 esp, 8
            //   8d8de0faffff         | lea                 ecx, [ebp - 0x520]
            //   51                   | push                ecx
            //   8d95bcf1ffff         | lea                 edx, [ebp - 0xe44]
            //   52                   | push                edx
            //   68c50b0000           | push                0xbc5
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_3 = { 8945ec 8b4d08 8b55e0 3b91a0af0600 7c02 eb44 }
            // n = 6, score = 100
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b55e0               | mov                 edx, dword ptr [ebp - 0x20]
            //   3b91a0af0600         | cmp                 edx, dword ptr [ecx + 0x6afa0]
            //   7c02                 | jl                  4
            //   eb44                 | jmp                 0x46

        $sequence_4 = { 50 68???????? 68???????? 8b0d???????? 51 8b15???????? 52 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   68????????           |                     
            //   68????????           |                     
            //   8b0d????????         |                     
            //   51                   | push                ecx
            //   8b15????????         |                     
            //   52                   | push                edx

        $sequence_5 = { e8???????? 8bc8 e8???????? 8b55bc 2bd0 8955cc 7446 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   8b55bc               | mov                 edx, dword ptr [ebp - 0x44]
            //   2bd0                 | sub                 edx, eax
            //   8955cc               | mov                 dword ptr [ebp - 0x34], edx
            //   7446                 | je                  0x48

        $sequence_6 = { 68???????? 8b55f8 52 ff15???????? 8945fc 837dfc00 7515 }
            // n = 7, score = 100
            //   68????????           |                     
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   7515                 | jne                 0x17

        $sequence_7 = { 8945c8 8945cc 68???????? 8b4d08 51 e8???????? 83c408 }
            // n = 7, score = 100
            //   8945c8               | mov                 dword ptr [ebp - 0x38], eax
            //   8945cc               | mov                 dword ptr [ebp - 0x34], eax
            //   68????????           |                     
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_8 = { 51 8b55e0 8b02 8b4de0 51 8b908c000000 ffd2 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   8b55e0               | mov                 edx, dword ptr [ebp - 0x20]
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   51                   | push                ecx
            //   8b908c000000         | mov                 edx, dword ptr [eax + 0x8c]
            //   ffd2                 | call                edx

        $sequence_9 = { 3b8568ffffff 721d 6a00 6a00 681f520000 e8???????? 83c40c }
            // n = 7, score = 100
            //   3b8568ffffff         | cmp                 eax, dword ptr [ebp - 0x98]
            //   721d                 | jb                  0x1f
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   681f520000           | push                0x521f
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

    condition:
        7 of them and filesize < 677888
}