rule win_blackbyte_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.blackbyte."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.blackbyte"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d6c2458 b802000000 b908000000 31d2 }
            // n = 4, score = 200
            //   488d6c2458           | lea                 ecx, [esp + 0x20]
            //   b802000000           | dec                 eax
            //   b908000000           | lea                 edx, [esp + 0x20]
            //   31d2                 | dec                 eax

        $sequence_1 = { 0f29442450 85ff 0f8e82010000 4c8b5c2450 }
            // n = 4, score = 200
            //   0f29442450           | jmp                 0x55
            //   85ff                 | dec                 eax
            //   0f8e82010000         | mov                 edx, dword ptr [ebp + 8]
            //   4c8b5c2450           | dec                 eax

        $sequence_2 = { 488d8424c0000000 e8???????? 89442460 895c2464 }
            // n = 4, score = 200
            //   488d8424c0000000     | dec                 eax
            //   e8????????           |                     
            //   89442460             | test                edi, edi
            //   895c2464             | jle                 0x18

        $sequence_3 = { 488d8424c0000000 31db 31c9 4889cf }
            // n = 4, score = 200
            //   488d8424c0000000     | inc                 ecx
            //   31db                 | mov                 edi, dword ptr [esp + 8]
            //   31c9                 | xor                 ebx, ebx
            //   4889cf               | movaps              xmmword ptr [esp + 0x50], xmm0

        $sequence_4 = { 488d7301 4889c2 4889cf 488b442468 }
            // n = 4, score = 200
            //   488d7301             | dec                 eax
            //   4889c2               | lea                 ebp, [esp + 0x40]
            //   4889cf               | dec                 eax
            //   488b442468           | mov                 dword ptr [esp + 0x50], eax

        $sequence_5 = { 488d6c2440 4889442450 48894c2460 4885ff }
            // n = 4, score = 200
            //   488d6c2440           | dec                 esp
            //   4889442450           | mov                 ebx, dword ptr [esp + 0x50]
            //   48894c2460           | movzx               esi, word ptr [ebp + 0x1cc]
            //   4885ff               | nop                 dword ptr [eax]

        $sequence_6 = { 488d8424c0000000 48898424a8000000 488d8c24a0000000 48898c24d8000000 }
            // n = 4, score = 200
            //   488d8424c0000000     | mov                 edi, ecx
            //   48898424a8000000     | dec                 eax
            //   488d8c24a0000000     | lea                 ebp, [esp + 0x58]
            //   48898c24d8000000     | mov                 eax, 1

        $sequence_7 = { 488d6c2440 4889442428 48895c2458 488b0d???????? 48894c2430 4889c8 e8???????? }
            // n = 7, score = 200
            //   488d6c2440           | movzx               esi, word ptr [ebp + 0x1cc]
            //   4889442428           | nop                 dword ptr [eax]
            //   48895c2458           | movaps              xmmword ptr [esp + 0x50], xmm0
            //   488b0d????????       |                     
            //   48894c2430           | test                edi, edi
            //   4889c8               | jle                 0x18a
            //   e8????????           |                     

        $sequence_8 = { 3b1d???????? 7cdb 33c0 488b5c2430 }
            // n = 4, score = 200
            //   3b1d????????         |                     
            //   7cdb                 | movaps              xmmword ptr [esp + 0x40], xmm0
            //   33c0                 | test                eax, eax
            //   488b5c2430           | jne                 0xdd

        $sequence_9 = { 0f11442440 0f1005???????? 0f114c2450 0f100d???????? 0f11442460 }
            // n = 5, score = 200
            //   0f11442440           | jne                 0xdd
            //   0f1005????????       |                     
            //   0f114c2450           | inc                 ecx
            //   0f100d????????       |                     
            //   0f11442460           | movups              xmm0, xmmword ptr [esp]

        $sequence_10 = { 3b1d???????? 7d09 488b0d???????? ebb0 }
            // n = 4, score = 200
            //   3b1d????????         |                     
            //   7d09                 | add                 esp, 0x20
            //   488b0d????????       |                     
            //   ebb0                 | jl                  0xffffffe4

        $sequence_11 = { 3b1f 72bd 8b842470100000 eb4c }
            // n = 4, score = 200
            //   3b1f                 | mov                 edi, dword ptr [esp + 0xd8]
            //   72bd                 | nop                 dword ptr [eax]
            //   8b842470100000       | dec                 esp
            //   eb4c                 | mov                 eax, ebx

        $sequence_12 = { 0f29442430 e8???????? 0f1003 4c8bc7 488d542430 488d4c2420 660f7f742430 }
            // n = 7, score = 200
            //   0f29442430           | movaps              xmmword ptr [esp + 0x30], xmm0
            //   e8????????           |                     
            //   0f1003               | movups              xmm0, xmmword ptr [ebx]
            //   4c8bc7               | dec                 esp
            //   488d542430           | mov                 eax, edi
            //   488d4c2420           | dec                 eax
            //   660f7f742430         | lea                 edx, [esp + 0x30]

        $sequence_13 = { 488d6c2458 b801000000 b9fb000000 31d2 31db 31f6 31ff }
            // n = 7, score = 200
            //   488d6c2458           | mov                 ebx, dword ptr [esp + 0x50]
            //   b801000000           | movzx               esi, word ptr [ebp + 0x1cc]
            //   b9fb000000           | movaps              xmmword ptr [esp + 0x50], xmm0
            //   31d2                 | test                edi, edi
            //   31db                 | jle                 0x18a
            //   31f6                 | dec                 esp
            //   31ff                 | mov                 ebx, dword ptr [esp + 0x50]

        $sequence_14 = { 3b1d???????? 7ce2 488b1d???????? 488bbc24d8000000 }
            // n = 4, score = 200
            //   3b1d????????         |                     
            //   7ce2                 | mov                 ebp, dword ptr [esp + 0x38]
            //   488b1d????????       |                     
            //   488bbc24d8000000     | dec                 eax

        $sequence_15 = { 0f29442440 e8???????? 85c0 0f85d7000000 }
            // n = 4, score = 200
            //   0f29442440           | dec                 eax
            //   e8????????           |                     
            //   85c0                 | lea                 ecx, [esp + 0x20]
            //   0f85d7000000         | movdqa              xmmword ptr [esp + 0x30], xmm6

    condition:
        7 of them and filesize < 9435136
}