rule win_blacklotus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.blacklotus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.blacklotus"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 443bca 7319 69c03f000100 4883c102 4103c0 41ffc1 440fb701 }
            // n = 7, score = 100
            //   443bca               | dec                 eax
            //   7319                 | mov                 ebp, dword ptr [esp + 0x38]
            //   69c03f000100         | dec                 eax
            //   4883c102             | mov                 esi, dword ptr [esp + 0x40]
            //   4103c0               | dec                 eax
            //   41ffc1               | mov                 edi, dword ptr [esp + 0x48]
            //   440fb701             | dec                 ecx

        $sequence_1 = { c745cfc1afbd03 c745d301138a6b c745d73a911141 c745db4f67dcea c745df97f2cfce }
            // n = 5, score = 100
            //   c745cfc1afbd03       | dec                 eax
            //   c745d301138a6b       | add                 ecx, 2
            //   c745d73a911141       | inc                 ecx
            //   c745db4f67dcea       | add                 eax, eax
            //   c745df97f2cfce       | inc                 ecx

        $sequence_2 = { 448bc6 488d155b1d0000 488bcb e8???????? 488bf0 }
            // n = 5, score = 100
            //   448bc6               | test                eax, eax
            //   488d155b1d0000       | mov                 cl, 0xe
            //   488bcb               | mov                 cl, byte ptr [ebx + 2]
            //   e8????????           |                     
            //   488bf0               | inc                 eax

        $sequence_3 = { 770b 418b4908 03ca 413bcb 770e 6641ffc2 4983c128 }
            // n = 7, score = 100
            //   770b                 | mov                 ebp, edx
            //   418b4908             | dec                 eax
            //   03ca                 | mov                 ebx, dword ptr [edi]
            //   413bcb               | xor                 esi, esi
            //   770e                 | push                edi
            //   6641ffc2             | dec                 eax
            //   4983c128             | sub                 esp, 0x20

        $sequence_4 = { 42883c10 4183fb3c 0f8c45ffffff 498d8af0000000 41b810000000 498bd6 }
            // n = 6, score = 100
            //   42883c10             | inc                 ebp
            //   4183fb3c             | xor                 ecx, ecx
            //   0f8c45ffffff         | dec                 eax
            //   498d8af0000000       | mov                 dword ptr [esp + 0x28], eax
            //   41b810000000         | dec                 esp
            //   498bd6               | mov                 eax, ebp

        $sequence_5 = { 488d1588f7ffff e8???????? 488b05???????? 488bcb ff5020 488b5c2430 488b742438 }
            // n = 7, score = 100
            //   488d1588f7ffff       | jb                  0x883
            //   e8????????           |                     
            //   488b05????????       |                     
            //   488bcb               | dec                 eax
            //   ff5020               | lea                 esi, [0x116b1]
            //   488b5c2430           | inc                 ebp
            //   488b742438           | test                eax, eax

        $sequence_6 = { 4632440c30 eb1b 418af1 83f804 }
            // n = 4, score = 100
            //   4632440c30           | inc                 esp
            //   eb1b                 | xor                 bl, al
            //   418af1               | inc                 ecx
            //   83f804               | mov                 al, bl

        $sequence_7 = { 4889442428 4c8bc5 488bd3 48897c2420 }
            // n = 4, score = 100
            //   4889442428           | inc                 esi
            //   4c8bc5               | xor                 al, byte ptr [esp + ecx + 0x30]
            //   488bd3               | jmp                 0x386
            //   48897c2420           | inc                 ecx

        $sequence_8 = { 740b 4883c602 483bf7 72bd eb0c bb03000000 eb05 }
            // n = 7, score = 100
            //   740b                 | lea                 ecx, [esp + 0x40]
            //   4883c602             | test                esi, esi
            //   483bf7               | je                  0x157b
            //   72bd                 | dec                 esi
            //   eb0c                 | dec                 esp
            //   bb03000000           | lea                 eax, [esp + 0x70]
            //   eb05                 | dec                 eax

        $sequence_9 = { 48897010 48897818 4c897020 55 488d68c8 4881ec30010000 4c8bd1 }
            // n = 7, score = 100
            //   48897010             | dec                 eax
            //   48897818             | mov                 ebx, dword ptr [eax + 0x40]
            //   4c897020             | mov                 ecx, 0x1f
            //   55                   | call                dword ptr [eax + 0x18]
            //   488d68c8             | dec                 esp
            //   4881ec30010000       | lea                 eax, [0x1144e]
            //   4c8bd1               | dec                 eax

    condition:
        7 of them and filesize < 181248
}