rule win_boldmove_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.boldmove."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.boldmove"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5f 5d e9???????? c7442404???????? 893424 e8???????? }
            // n = 6, score = 100
            //   5f                   | pop                 edi
            //   5d                   | pop                 ebp
            //   e9????????           |                     
            //   c7442404????????     |                     
            //   893424               | mov                 dword ptr [esp], esi
            //   e8????????           |                     

        $sequence_1 = { 83e00f 740f dd442420 dc0cc5e0694100 dd5c2420 83e6f0 0f853d070000 }
            // n = 7, score = 100
            //   83e00f               | and                 eax, 0xf
            //   740f                 | je                  0x11
            //   dd442420             | fld                 qword ptr [esp + 0x20]
            //   dc0cc5e0694100       | fmul                qword ptr [eax*8 + 0x4169e0]
            //   dd5c2420             | fstp                qword ptr [esp + 0x20]
            //   83e6f0               | and                 esi, 0xfffffff0
            //   0f853d070000         | jne                 0x743

        $sequence_2 = { 8b4da0 89442404 894c2408 8945a0 }
            // n = 4, score = 100
            //   8b4da0               | mov                 ecx, dword ptr [ebp - 0x60]
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   894c2408             | mov                 dword ptr [esp + 8], ecx
            //   8945a0               | mov                 dword ptr [ebp - 0x60], eax

        $sequence_3 = { 894dcc 8945d0 e8???????? 8b4dcc 8b45d0 }
            // n = 5, score = 100
            //   894dcc               | mov                 dword ptr [ebp - 0x34], ecx
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   e8????????           |                     
            //   8b4dcc               | mov                 ecx, dword ptr [ebp - 0x34]
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]

        $sequence_4 = { c744240434000000 89442408 c7042411000000 e8???????? 893424 89442404 }
            // n = 6, score = 100
            //   c744240434000000     | mov                 dword ptr [esp + 4], 0x34
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   c7042411000000       | mov                 dword ptr [esp], 0x11
            //   e8????????           |                     
            //   893424               | mov                 dword ptr [esp], esi
            //   89442404             | mov                 dword ptr [esp + 4], eax

        $sequence_5 = { 85f6 0f84dd040000 ddd8 ddd8 83fe01 0f845a050000 }
            // n = 6, score = 100
            //   85f6                 | test                esi, esi
            //   0f84dd040000         | je                  0x4e3
            //   ddd8                 | fstp                st(0)
            //   ddd8                 | fstp                st(0)
            //   83fe01               | cmp                 esi, 1
            //   0f845a050000         | je                  0x560

        $sequence_6 = { 89e5 56 53 8db5f8fbffff 81ec20040000 8b5d10 }
            // n = 6, score = 100
            //   89e5                 | mov                 ebp, esp
            //   56                   | push                esi
            //   53                   | push                ebx
            //   8db5f8fbffff         | lea                 esi, [ebp - 0x408]
            //   81ec20040000         | sub                 esp, 0x420
            //   8b5d10               | mov                 ebx, dword ptr [ebp + 0x10]

        $sequence_7 = { 99 f7ff bf04000000 0fb63406 89c8 99 f7ff }
            // n = 7, score = 100
            //   99                   | cdq                 
            //   f7ff                 | idiv                edi
            //   bf04000000           | mov                 edi, 4
            //   0fb63406             | movzx               esi, byte ptr [esi + eax]
            //   89c8                 | mov                 eax, ecx
            //   99                   | cdq                 
            //   f7ff                 | idiv                edi

        $sequence_8 = { 5e 5f 5d c3 55 31c0 b910000000 }
            // n = 7, score = 100
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   31c0                 | xor                 eax, eax
            //   b910000000           | mov                 ecx, 0x10

        $sequence_9 = { 85c0 7408 890424 e8???????? 43 81fb00010000 75e4 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7408                 | je                  0xa
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   43                   | inc                 ebx
            //   81fb00010000         | cmp                 ebx, 0x100
            //   75e4                 | jne                 0xffffffe6

    condition:
        7 of them and filesize < 242688
}